//---------------------------------------------------------------------------------------
//	SPCTileView.h created by erik on Tue 28-Jul-1998
//	This code is part of the Spectre Project by Erik Doernenburg. For copyright details
//	see GNU public license version 2 or above. No warranties implied. Use at own risk.
//	More information can be found at <http://www.object-factory.com/~erik/Spectre>.
//	@(#)$Id: SPCTileView.h,v 1.2 1998/09/27 16:08:35 erik Exp $
//---------------------------------------------------------------------------------------

typedef struct
{
    unsigned delegateRespondsToDrop : 1;
} _TVFlags;


@interface SPCTileView : NSView
{
    _TVFlags flags;
    NSString *appState;
    NSString *appPath;
    NSImage	 *appIcon;
    NSPoint	 imageOrigin;
    id		 target;
    SEL		 action;
    SEL		 altAction;
    SEL		 doubleAction;
    SEL		 doubleCommandAction;
    id		 delegate;
}

+ (NSSize)tileSize;

- (void)setAppPath:(NSString *)aPath;
- (NSString *)appPath;

- (void)setAppState:(NSString *)newState;
- (NSString *)appState;

- (void)setTarget:(id)anObject;
- (id)target;

- (void)setAction:(SEL)aSelector;
- (SEL)action;

- (void)setDoubleAction:(SEL)aSelector;
- (SEL)doubleAction;

- (void)setAltAction:(SEL)aSelector;
- (SEL)altAction;

- (void)setDoubleCommandAction:(SEL)aSelector;
- (SEL)doubleCommandAction;

- (void)setDelegate:(id)anObject;
- (id)delegate;

@end


@interface NSObject(SPCTileViewDelegateInformalProtocol)
- (void)tileView:(SPCTileView *)view acceptedDroppedPath:(NSString *)path;
@end


