//---------------------------------------------------------------------------------------
//	SPCPoint.m created by erik on Sat 01-Aug-1998
//	This code is part of the Spectre Project by Erik Doernenburg. For copyright details
//	see GNU public license version 2 or above. No warranties implied. Use at own risk.
//	More information can be found at <http://www.object-factory.com/~erik/Spectre>.
//	@(#)$Id: SPCPoint.m,v 1.3 1998/08/10 22:05:43 erik Exp $
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import "SPCPoint.h"

//---------------------------------------------------------------------------------------
    @implementation SPCPoint
//---------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------
//	FACTORY
//---------------------------------------------------------------------------------------

+ (id)pointWithX:(int)xValue andY:(int)yValue
{	
    return [[[self alloc] initWithX:xValue andY:yValue] autorelease];
}


//---------------------------------------------------------------------------------------
// INITIALISATION
//---------------------------------------------------------------------------------------

- (id)initWithX:(int)xValue andY:(int)yValue;
{
    [super init];
    x = xValue;
    y = yValue;
    return self;
}


//---------------------------------------------------------------------------------------
//	ACCESSOR METHODS
//---------------------------------------------------------------------------------------

- (int)x;
{
    return x;
}


- (int)y;
{
    return y;
}


//---------------------------------------------------------------------------------------
//	COLLECTION SUPPORT
//---------------------------------------------------------------------------------------

- (unsigned int)hash;
{
    return abs(x + 100) % abs(y + 100);
}


- (BOOL)isEqual:(SPCPoint *)other;
{
    if([other isKindOfClass:isa] == NO)
        return NO;
    return ((self->x == other->x) && (self->y == other->y));
}


//---------------------------------------------------------------------------------------
//	NSCOPYING
//---------------------------------------------------------------------------------------

- (id)copyWithZone:(NSZone *)aZone;
{
    if(NSShouldRetainWithZone(self, aZone))
        return [self retain];
    return [[SPCPoint allocWithZone:aZone] initWithX:x andY:y];
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------
