//---------------------------------------------------------------------------------------
//	SPCGrid.m created by erik on Thu 06-Aug-1998
//	This code is part of the Spectre Project by Erik Doernenburg. For copyright details
//	see GNU public license version 2 or above. No warranties implied. Use at own risk.
//	More information can be found at <http://www.object-factory.com/~erik/Spectre>.
//	@(#)$Id: SPCGrid.m,v 1.2 1998/08/10 22:05:40 erik Exp $
//---------------------------------------------------------------------------------------

#import <Foundation/Foundation.h>
#import "SPCPoint.h"
#import "SPCGrid.h"

//---------------------------------------------------------------------------------------
    @implementation SPCGrid
//---------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------
//	INIT & DEALLOC
//---------------------------------------------------------------------------------------

- (id)init
{
    [super init];
    storage = [[NSMutableDictionary allocWithZone:[self zone]] init];
    return self;
}


- (void)dealloc
{
    [storage release];
    [super dealloc];
}


//---------------------------------------------------------------------------------------
//	ACCESSING OBJECTS BY POSITION
//---------------------------------------------------------------------------------------

- (void)setObject:(id)object atPosition:(SPCPoint *)p;
{
    [storage setObject:object forKey:p];
}


- (id)objectAtPosition:(SPCPoint *)p;
{
    return [storage objectForKey:p];
}


- (void)removeObjectAtPosition:(SPCPoint *)p;
{
    [storage removeObjectForKey:p];
}


//---------------------------------------------------------------------------------------
//	ACCESSING ALL OBJECTS
//---------------------------------------------------------------------------------------

- (NSArray *)allObjects;
{
    return [storage allValues];
}


- (NSEnumerator *)positionEnumerator;
{
    return [storage keyEnumerator];
}


- (NSEnumerator *)objectEnumerator;
{
    return [storage objectEnumerator];
}

    
//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------
