//---------------------------------------------------------------------------------------
//	AppController.m created by erik on Fri 03-Jul-1998
//	This code is part of the Spectre Project by Erik Doernenburg. For copyright details
//	see GNU public license version 2 or above. No warranties implied. Use at own risk.
//	More information can be found at <http://www.object-factory.com/~erik/Spectre>.
//	@(#)$Id: AppController.m,v 1.5 1998/09/27 21:19:24 erik Exp $
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import "LocalizableStrings.h"
#import "PrefController.h"
#import "DockController.h"
#import "EDApplication.h"
#import "AppController.h"



//---------------------------------------------------------------------------------------
    @implementation AppController
//---------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------
//	INITALISATION
//---------------------------------------------------------------------------------------

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(redisplay:) name:NSUserDefaultsDidChangeNotification object:nil];

    [self redisplay:aNotification];

    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(userDefaultsChanged:) name:NSUserDefaultsDidChangeNotification object:nil];

    [self userDefaultsChanged:aNotification];
}


- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    [dockController release];
}


- (BOOL)applicationShouldTerminate:(NSApplication *)sender
{
    return NSRunAlertPanel(ATITLE_CONFIRM, ATEXT_REALLY_QUIT, BTN_QUIT, BTN_CANCEL, nil) == NSAlertDefaultReturn;
}


//---------------------------------------------------------------------------------------
//	LAUNCH METHOD MANAGEMENT
//---------------------------------------------------------------------------------------

- (void)redisplay:(NSNotification *)aNotification;
{
    if([[NSUserDefaults standardUserDefaults] boolForKey:SPCDockKey] == NO)
        {
        [dockController release];
        dockController = nil;
        }
    else
        {
        if(dockController == nil)
            dockController = [[DockController alloc] init];
        }
}


//---------------------------------------------------------------------------------------
//	INFO PANEL
//---------------------------------------------------------------------------------------

- (void)showAboutPanel:(id)sender;
{
    if(aboutPanel == nil)
        {
        extern double SpectreVersionNumber;
        
        [NSBundle loadNibNamed:@"About" owner:self];
        [versionField setStringValue:[NSString stringWithFormat:[versionField stringValue], SpectreVersionNumber]];
        }
    [aboutPanel makeKeyAndOrderFront:self];
}


- (void)windowWillClose:(NSNotification *)aNotification;
{
    if((aboutPanel != nil) && ([aNotification object] == aboutPanel))
        {
        [aboutPanel autorelease];
        aboutPanel = nil;
        }
}


//---------------------------------------------------------------------------------------
//	OTHER STUFF
//---------------------------------------------------------------------------------------

- (void)gotoHomepage:(id)sender;
{
    [(EDApplication *)[NSApplication sharedApplication] openURL:@"http://www.object-factory.com/~erik/Spectre/"];
}


//---------------------------------------------------------------------------------------
//	(don't) Hide management
//---------------------------------------------------------------------------------------

- (void)userDefaultsChanged:(NSNotification *)notification;
{
    dontHideDock	= [[NSUserDefaults standardUserDefaults] boolForKey:SPCDockDontHideKey];
}


- (void)applicationDidHide: (NSNotification *)notification {
    if(dontHideDock) {
        [[NSApplication sharedApplication] unhideWithoutActivation];
    }
}

//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------


