/*$Id: SenInvocationEnumerator.m,v 1.2 1998/12/20 16:40:36 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenInvocationEnumerator.h"

@implementation SenInvocationEnumerator

+ (id) instanceInvocationEnumeratorForClass:(Class) aClass
{
    return [[[self alloc] initForClass:aClass] autorelease];
}


- (void) goNextMethodList
{
    mlist = class_nextMethodList (class, &iterator);
    count = (mlist != NULL) ? mlist->method_count : -1;
}


- (id) initForClass:(Class) aClass
{
    self = [super init];
    class = aClass;
    iterator = NULL;
    [self goNextMethodList];
    return self;
}


- (id) nextObject
{
    if (mlist == NULL) {
        return nil;
    }
    else {
        SEL nextSelector = mlist->method_list[count--].method_name;
        if (count == -1) {
            [self goNextMethodList];
        }
        if (sel_isMapped(nextSelector)) {
            NSInvocation *invocation = [NSInvocation invocationWithMethodSignature:[class instanceMethodSignatureForSelector:nextSelector]];
            [invocation setSelector:nextSelector];
            return invocation;
        }
        else {
            return [self nextObject];
        }
    }
}
@end
