/*$Id: NSObject_SenAdditions.m,v 1.2 1998/12/20 16:40:16 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "NSObject_SenAdditions.h"
#import "SenCollection.h"
#import <Foundation/Foundation.h>


@implementation NSObject (SenAdditions)
- (void) performSelector:(SEL) aSelector withEachObjectInCollection:(id <SenCollection>) aCollection
{
    NSEnumerator *collectionEnumerator = [aCollection objectEnumerator];
    id each;
    while (each = [collectionEnumerator nextObject]) {
        [self performSelector:aSelector withObject:each];
    }
}


- (void) performSelector:(SEL) aSelector withEachObjectInCollection:(id <SenCollection>) aCollection withObject:(id) anObject
{
    NSEnumerator *collectionEnumerator = [aCollection objectEnumerator];
    id each;
    while (each = [collectionEnumerator nextObject]) {
        [self performSelector:aSelector withObject:each withObject:anObject];
    }
}
@end
