//*$Id: SenTestTool.m,v 1.2 1998/12/20 16:54:59 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.


#import "SenTestTool.h"
#import <SenFoundation/SenFoundation.h>

#define ERROR 1
#define NO_ERROR 0

static NSString *SelfTestDefault = @"SelfTest";
static NSString *TestProbeName = @"SenTestProbe";

@implementation SenTestTool

+ (void) initialize
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSDictionary *registeredDefaults = [NSDictionary dictionaryWithObject:@"YES" forKey:SelfTestDefault];
    [defaults registerDefaults:registeredDefaults];
}


+ (NSArray *) arrayFromPropertyList:(NSString *) string
{
    id plist = nil;
    NS_DURING
        plist = [string propertyList];
    NS_HANDLER
        plist = nil;
    NS_ENDHANDLER

    if (plist != nil) {
        return (([plist isKindOfClass:[NSArray class]]) ? plist : [NSArray arrayWithObject:plist]);
    }
    return nil;
}


+ (void) showUsage
{
    NSLog (@"%@ Could not parse arguments '%@'. The last argument must be a bundle path or an array of bundle paths in property list format.",
           [[NSProcessInfo processInfo] processName],
           [[[NSProcessInfo processInfo] arguments] lastObject]);
}


+ (NSArray *) bundlePaths
{
    return [self arrayFromPropertyList:[[[NSProcessInfo processInfo] arguments] lastObject]];
}


+ (BOOL) areBundlesLoaded
{
    if ([[[NSProcessInfo processInfo] arguments] count] > 1) {
        NSEnumerator *pathEnumerator = [[self bundlePaths] objectEnumerator];
        NSString *eachPath = nil;

        while (eachPath = [pathEnumerator nextObject]){
            if (![[NSBundle bundleWithPath:eachPath] load]) {
                return NO;
            }
        }
    }
    return YES;
}


+ (NSString *) pathForResource:(NSString *) name inDirectories:(NSArray *) paths
{
    NSEnumerator *pathEnumerator = [paths objectEnumerator];
    id each;
    while (each = [pathEnumerator nextObject]){
        NSString *fullPath = [[NSArray arrayWithObjects:each, name, nil] componentsJoinedByString:@"/"];
        if ([[NSFileManager defaultManager] fileExistsAtPath:fullPath]) {
            return fullPath;
        }
    }
    return nil;
}


+ (BOOL) isTestingKitLoaded
{
    if (NSClassFromString (TestProbeName) == nil) {
        NSBundle *testingKit = [NSBundle bundleWithPath:
            [self pathForResource:@"Frameworks/SenTestingKit.framework"
                    inDirectories:NSSearchPathForDirectoriesInDomains (NSAllLibrariesDirectory, NSAllDomainsMask, YES)]];
        return [testingKit classNamed:TestProbeName] != nil;
    }
    return YES;
}


+ (NSString *) executablePath
{
    return [[NSBundle bundleWithPath:[[self bundlePaths] lastObject]] executablePath];
}


+ (NSArray *) arguments
{
    NSMutableArray *arguments = [NSMutableArray arrayWithArray:[[NSProcessInfo processInfo] arguments]];
    [arguments setArgumentDefaultValue:@"YES" forKey:SelfTestDefault];
    return arguments;
}


+ (int) run
{
    BOOL result = ERROR;

    NS_DURING
        if ([self areBundlesLoaded] && [self isTestingKitLoaded]) {
            [[NSRunLoop currentRunLoop] run];
        }
        else {
            // FIXME Assumes only one executable bundle.
            NSTask *task =  [NSTask launchedTaskWithLaunchPath:[self executablePath] arguments:[self arguments]];
            [task waitUntilExit];
            result = [task terminationStatus];
        };
    NS_HANDLER
        [self showUsage];        
        result = ERROR;
    NS_ENDHANDLER
    
    return result;
}
@end
