/*$Id: InfoPanelController.m,v 1.2 1998/12/20 16:54:45 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "InfoPanelController.h"
#import <SenTestingKit/SenTestingKit.h>
#import <SenFoundation/SenFoundation.h>

#define VERSION_KEY  @"Version"

@implementation InfoPanelController

- (id) init
{
    return [super initWithWindowNibName:@"InfoPanel"];
}

- (NSString *) applicationVersion
{
    return [[NSBundle mainBundle] fullVersionString];
}

- (NSString *) testingKitVersion
{
    return [[NSBundle bundleForClass:[SenTestCase class]] fullVersionString];
}


- (IBAction) showWindow:(id)sender
{
    [[self window] center];
    [applicationVersionField setStringValue:[self applicationVersion]];
    [testingKitVersionField setStringValue:[self testingKitVersion]];
    [super showWindow:sender];
}
@end
