/*$Id: SenTestTest.m,v 1.1 1998/12/20 16:51:58 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#ifdef TESTING
// Quick hack to avoid including these tests in the framework for all clients to see.

#import "SenTestTest.h"

@implementation SenFailureTest
- (void) _test
{
    shouldBeEqual (@"a", @"b");
}

- (void) failThrice
{
    shouldBeEqual (@"a", @"A");
    shouldBeEqual (@"a", @"A");
    shouldRaise ([@"a" isEqualToString:@"x"]);
}
@end


@implementation SenErrorTest
- (void) _test
{
    NSArray *emptyArray = [NSArray array];
    NSLog (@"%@", [emptyArray objectAtIndex:0]);
}
@end


@implementation SenSuccessTest
- (void) _test
{
    shouldBeEqual (@"a", @"a");
}
@end


@implementation SenSupersuite
- (void) test1
{
}

- (void) test2
{
}

- (void) test3
{
}

- (void) notATest
{
}
@end


@implementation SenSubsuite
- (void) test4
{
}
@end


@implementation SenTestTest
- (void) setUp
{
    RETAIN (failureTest, [SenFailureTest testCaseWithSelector:@selector(_test)]);
    RETAIN (errorTest, [SenErrorTest testCaseWithSelector:@selector(_test)]);
    RETAIN (successTest, [SenSuccessTest testCaseWithSelector:@selector(_test)]);
}


- (void) tearDown
{
    RELEASE (failureTest);
    RELEASE (errorTest);
    RELEASE (successTest);
}


- (void) testFailure
{
    SenTestRun *failedRun = [failureTest run];
    should ([failedRun failureCount] == 1);
    should ([failedRun errorCount] == 0);
    shouldnt ([failedRun hasSucceeded]);
}


- (void) testError
{
    SenTestRun *errorRun = [errorTest run];
    should ([errorRun failureCount] == 0);
    should ([errorRun errorCount] == 1);
    shouldnt ([errorRun hasSucceeded]);
}


- (void)  testSuccess
{
    SenTestRun *successRun = [successTest run];
    should ([successRun failureCount] == 0);
    should ([successRun errorCount] == 0);
    should ([successRun hasSucceeded]);
}


- (void) testDefaultSuite
{
    SenTestSuite *suite = [SenTestSuite testSuiteWithName:@"Composite"];
    [suite addTest:[SenSupersuite defaultTestSuite]];
    [suite addTest:[SenSubsuite defaultTestSuite]];
    should ([[SenSupersuite defaultTestSuite] testCaseCount] == 3);
    should ([[SenSubsuite defaultTestSuite] testCaseCount] == 1);
    should ([suite testCaseCount] == [[SenSupersuite defaultTestSuite] testCaseCount] + [[SenSubsuite defaultTestSuite] testCaseCount]);
}


- (void) testContinueOrRaise
{
    SenTestCase *failThrice = [SenFailureTest testCaseWithSelector:@selector(failThrice)];

    [failThrice raiseAfterFailure];
    should ([[failThrice run] failureCount] == 1);
    [failThrice continueAfterFailure];
    should ([[failThrice run] failureCount] == 3);
}
@end
#endif