/*$Id: SenTestSuite.m,v 1.2 1998/12/20 16:51:48 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestSuite.h"
#import "SenTestCase.h"
#import "SenTestSuiteRun.h"

#import <SenFoundation/SenFoundation.h>
#import <Foundation/Foundation.h>

#import <SenFoundation/SenFoundation.h>

@implementation SenTestSuite

+ (id) testSuiteWithName:(NSString *) aName
{
    return [[[self alloc] initWithName:aName] autorelease];
}


+ (SenTestSuite *) defaultTestSuite
{
    SenTestSuite *fullTestSuite = [self testSuiteWithName:@"Complete Test Suite"];
    [fullTestSuite addTests:[[[SenTestCase allSubclasses] collectionByPerformingSelector:_cmd] asArray]];
    return fullTestSuite;   
}


- (id) initWithName:(NSString *) aName
{
    self = [super init];
    name = [aName copy];
    tests = [[NSMutableArray alloc] init];
    return self;
}


- (id) initWithCoder:(NSCoder *) aCoder
{
    name = [[aCoder decodeObject] retain];
    tests = [[aCoder decodeObject] retain];
    return self;
}


- (void) encodeWithCoder:(NSCoder *) aCoder
{
    [aCoder encodeObject:name];
    [aCoder encodeObject:tests];
}


- (void) dealloc
{
    RELEASE (name);
    RELEASE (tests);
    [super dealloc];
}


- (NSString *) name
{
    return name;
}


- (NSString *) description
{
    return [self name];
}


- (void) addTest:(SenTest *) aTest
{
    if (aTest != nil) {
        [tests addObject:aTest];   
    }
}


- (void) addTests:(id <SenCollection>) aCollection;
{
    [self performSelector:@selector(addTest:) withEachObjectInCollection:aCollection];
}


- (unsigned int) testCaseCount
{
    return [tests sumWithUnsignedIntSelector:_cmd];
}


- (Class) testRunClass
{
    return [SenTestSuiteRun class];
}


- (void) performTest:(SenTestRun *) aTestRun
{
    if (![self isEmpty]) {
        [aTestRun start];
        [aTestRun performSelector:@selector (addTestRun:) withEachObjectInCollection:[tests collectionByPerformingSelector:@selector(run)]];
        [aTestRun stop];
    }
}
@end
