/*$Id: SenTestCase.m,v 1.2 1998/12/20 16:51:23 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestCase.h"
#import "SenTestSuite.h"
#import "SenTestCaseRun.h"
#import "NSException_SenTestFailure.h"

#import <SenFoundation/SenFoundation.h>
#import <Foundation/Foundation.h>


// FIXME Handling of name, and limitation classForCoder limitation because 
// we were lazy to communicate with distributed notifications.

@implementation SenTestCase

- (id) initWithInvocation:(NSInvocation *) anInvocation
{
    self = [super init];
    [self continueAfterFailure];
    RETAIN (invocation, anInvocation);
    RETAIN (name, ([NSString stringWithFormat:@"-[%@ %@]", NSStringFromClass([self class]), NSStringFromSelector([invocation selector])]));
    [invocation setTarget:self];
    return self;
}


+ (id) testCaseWithInvocation:(NSInvocation *) anInvocation
{
    return [[[self alloc] initWithInvocation:anInvocation] autorelease];
}


- (id) initWithSelector:(SEL) aSelector
{
    NSInvocation *anInvocation = [NSInvocation invocationWithMethodSignature:[self methodSignatureForSelector:aSelector]];
    [anInvocation setSelector:aSelector];
    return [self initWithInvocation:anInvocation];
}


+ (id) testCaseWithSelector:(SEL) aSelector
{
    return [[[self alloc] initWithSelector:aSelector] autorelease];
}


- (Class) classForCoder
{
    return [SenTestCase class];
}


- (id) initWithCoder:(NSCoder *) aCoder
{
    invocation = [[aCoder decodeObject] retain];
    [aCoder decodeValueOfObjCType:@encode(SEL) at:&failureAction];
    name = [[aCoder decodeObject] retain];
    return self;
}


- (void) encodeWithCoder:(NSCoder *) aCoder
{
    [aCoder encodeObject:invocation];
    [aCoder encodeValueOfObjCType:@encode(SEL) at:&failureAction];
    [aCoder encodeObject:name];
}


- (SEL) selector
{
    return [invocation selector];
}


- (unsigned int) testCaseCount
{
    return 1;
}



- (NSString *) name
{
    return name;
}


- (NSString *) description
{
    return [self name];
}


- (void) dealloc
{
    RELEASE (invocation);
    RELEASE (name);
    [super dealloc];
}


- (void) setUp
{
}


- (void) tearDown
{
}


- (void) continueAfterFailure
{
    failureAction = @selector(logException:);
}


- (void) raiseAfterFailure
{
    failureAction = @selector(raiseException:);
}


- (void) logException:(NSException *) anException
{
    [run addException: anException];
}


- (void) raiseException:(NSException *) anException
{
    [anException raise];    
}


- (void) failWithException:(NSException *) anException
{
    [self performSelector:failureAction withObject:anException];
}


- (Class) testRunClass
{
    return [SenTestCaseRun class];
}


- (void) performTest:(SenTestRun *) aTestRun
{
    NSException *exception = nil;

    RETAIN(run, aTestRun);
    [self setUp];
    [run start];
    NS_DURING
        [invocation invoke];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER
    [run stop];
    [self tearDown];

    if (exception != nil) {
        [self logException:exception];
    }
    RELEASE (run);
}
@end


@implementation SenTestCase (Suite)

NSString *DefaultTestMethodPrefix = @"test";
static NSString *testMethodPrefix = nil;


- (void) prototypeTestMethod
{
}


+ (NSString *) testMethodPrefix
{
    return (testMethodPrefix != nil) ? testMethodPrefix : DefaultTestMethodPrefix;
}


+ (void) setMethodPrefix:(NSString *) aPrefix
{
    RETAIN (testMethodPrefix,aPrefix);
}


+ (BOOL) isTestingInvocation:(NSInvocation *) anInvocation
{
    return [NSStringFromSelector([anInvocation selector]) hasPrefix:[self testMethodPrefix]]  &&
        [[anInvocation methodSignature] isEqual:[self instanceMethodSignatureForSelector:@selector(prototypeTestMethod)]];
}


+ (id) defaultTestSuite
{
    SenTestSuite *suite = [SenTestSuite testSuiteWithName:NSStringFromClass(self)];
    NSEnumerator *invocationEnumerator = [self instanceInvocationEnumerator];
    NSInvocation *eachInvocation;

    while (eachInvocation = [invocationEnumerator nextObject]) {
        if ([self isTestingInvocation:eachInvocation]) {
            [suite addTest:[self testCaseWithInvocation:eachInvocation]];
        }
    }
    return suite;
}
@end
