// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OATabbedWindowController.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "OATabViewController.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OATabbedWindowController.m,v 1.3 1998/12/08 04:07:30 kc Exp $")

#ifdef YELLOW_BOX

@interface OATabbedWindowController (Private)
@end

@implementation OATabbedWindowController

//
// API
//

- (void)refreshUserInterface;
{
    NSEnumerator *itemEnumerator;
    NSTabViewItem *item;

    itemEnumerator = [[tabView tabViewItems] objectEnumerator];
    while ((item = [itemEnumerator nextObject]))
        [[item identifier] refreshUserInterface];
}

- (OATabViewController *)currentTabViewController;
{
    return [[tabView selectedTabViewItem] identifier];
}


//
// NSObject subclass
//

- (void)forwardInvocation:(NSInvocation *)invocation
{
    [invocation invokeWithTarget:[self currentTabViewController]];
}

- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector
{
    NSMethodSignature *signature;

    signature = [super methodSignatureForSelector:aSelector];
    if (signature)
        return signature;
    return [[self currentTabViewController] methodSignatureForSelector:aSelector];
}

- (BOOL)respondsToSelector:(SEL)aSelector
{
    return [super respondsToSelector:aSelector] || [[self currentTabViewController] respondsToSelector:aSelector];
}


//
// NSWindowController subclass
//

- (BOOL)validateMenuItem:(NSMenuItem *)anItem
{
    OATabViewController *currentTabViewController;
    
    currentTabViewController = [self currentTabViewController];
    if (currentTabViewController && ![currentTabViewController validateMenuItem:anItem])
        return NO;

    return [super validateMenuItem:anItem];
}    


//
// NSTabView delegate
//

- (void)tabView:(NSTabView *)aTabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem;
{
    if ([[tabViewItem identifier] respondsToSelector:@selector(willSelectInTabView:)])
        [[tabViewItem identifier] willSelectInTabView:aTabView];
}

@end


@implementation OATabbedWindowController (Private)
@end

#endif
