// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OAPlusTableView.h,v 1.6 1998/12/08 04:07:21 kc Exp $

#import <AppKit/NSTableView.h>

// This provides a 'plus' button in the cornerView.  Clicking on the plus button allows the user to add columns.  Additionally, columns may be selected and removed from the display  by hitting the delete key.

@class NSMatrix, NSWindow;

@interface OAPlusTableView : NSTableView
{
    NSMutableArray *inactiveTableColumns;
    NSMatrix *popUpMatrix;
    NSWindow *popUpWindow;
}

- (NSArray *)inactiveTableColumns;

- (void)activateTableColumn:(NSTableColumn *)column;
- (void)inactivateTableColumn:(NSTableColumn *)column;
- (BOOL)isTableColumnActive:(NSTableColumn *)column;

- (void)addInactiveTableColumn:(NSTableColumn *)column;
- (void)removeInactiveTableColumn:(NSTableColumn *)column;

@end

@interface NSObject (OAPlusTableViewDelegate)
- (BOOL)tableView:(OAPlusTableView *)tableView shouldAllowActivationOfColumn:(NSTableColumn *)tableView;
@end
