// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSControl-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/OpenStepExtensions.subproj/NSControl-OAExtensions.m,v 1.2 1998/12/08 04:06:36 kc Exp $")

@implementation NSControl (OAExtensions)

- (void)setCharacterWrappingStringValue:(NSString *)string;
{
    NSAttributedString *attributedString;

    attributedString = [[NSAttributedString alloc] initWithString:string attributes:[self attributedStringDictionaryWithCharacterWrapping]];

    [self setAttributedStringValue:attributedString];

    [attributedString release];
}

- (NSMutableDictionary *)attributedStringDictionaryWithCharacterWrapping;
{
    NSMutableParagraphStyle *paragraphStyle;
    NSMutableDictionary *attributes;

    paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    [paragraphStyle setLineBreakMode:NSLineBreakByCharWrapping];
    [paragraphStyle setAlignment:[self alignment]];
    
    attributes = [[NSMutableDictionary alloc] initWithObjectsAndKeys:paragraphStyle,
        NSParagraphStyleAttributeName, [self font], NSFontAttributeName, nil];
    [paragraphStyle release];

    return [attributes autorelease];
}

@end
