
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


/* *** supported build switches *** */

//#define	MACOSX						1		// must be set
//#define	GFXLIB_MESA26				0		// select Mesa 2.6 Framework as graphics library
//#define	GFXLIB_CONIX				1		// select Conix 1.4a Framework as graphics library
//#define	INTERCEPTOR_HATES_EPS	0	// set this to 1 if your GL uses Interceptor as the Window System interface
//#define	VERBOSE						0		// normal debug output level
//#define	VERBOSE1						0		// GLUTVisual matching subsystem debug output


#if defined(GFXLIB_CONIX)
# define INTERCEPTOR_HATES_EPS
#endif




#import <AppKit/AppKit.h>
#if defined(GFXLIB_MESA26)
# import <GL/gl.h>
# import <GL/glu.h>
#endif
#if defined(GFXLIB_CONIX)
# import <OpenGL/gl.h>
# import <OpenGL/glu.h>
#endif
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <stdarg.h>
#import <sys/time.h>

#import "macxglut_utilities.h"

@class GLUTWindow, GLUTOverlay, GLUTVisual, GLUTMenu;




#define	GLUT_PERIODIC_DELAY	0.14

	/* many greetings from Windows ! */
#ifndef APIENTRY
#define APIENTRY
#endif


/* *** types *** */

typedef void	(*GLUTKeyboardCallback)(unsigned char key, int x, int y);
typedef void	(*GLUTMouseCallback)(int button, int state, int x, int y);
typedef void	(*GLUTMotionCallback)(int x, int y);
typedef void	(*GLUTVisibilityCallback)(int state);
typedef void	(*GLUTEntryCallback)(int state);
typedef void	(*GLUTWindowStatusCallback)(int state);
typedef void	(*GLUTSpecialCallback)(int key, int x, int y);
typedef void	(*GLUTDisplayCallback)(void);
typedef void	(*GLUTReshapeCallback)(int width, int height);
typedef void	(*GLUTMenuCallback)(int value);
typedef void	(*GLUTMenuStatusCallback)(int state, int x, int y);
typedef void	(*GLUTSpaceballMotionCallback)(int x, int y, int z);
typedef void	(*GLUTSpaceballRotateCallback)(int x, int y, int z);
typedef void	(*GLUTSpaceballButtonCallback)(int button, int state);
typedef void	(*GLUTButtonBoxCallback)(int button, int state);
typedef void	(*GLUTDialCallback)(int dial, int value);
typedef void	(*GLUTTabletMotionCallback)(int x, int y);
typedef void	(*GLUTTabletButtonCallback)(int button, int state, int x, int y);
typedef void	(*GLUTJoystickCallback)(unsigned int buttonMask, int x, int y, int z);
typedef void	(*GLUTIdleCallback)(void);
typedef void	(*GLUTTimerCallback)(int value);


/* *** GLUT Window protocol *** */

/*
 *	This protocol defines the common properties of both types of GLUT windows (root and sub windows).
 *	It's atopted by a NSWindow subclass (for root windows) and NSView subclass (for subwindows)
 */


@protocol GLUTWindows <NSObject>

	/* accessors */
- (GLUTVisual *)visual;
- (GLUTOverlay *)overlay;
- (NSPoint)windowPositionRelativeToParent: (BOOL)yesno;
- (NSSize)windowSize;
- (BOOL)isSubWindow;
- (BOOL)isDamaged;
- (id <GLUTWindows>)parentWindow;
- (int)numberOfSubWindows;
- (NSWindow *)nativeWindow;
- (int)modifierFlags;
- (BOOL)ignoreKeyRepeats;
- (void)setIgnoreKeyRepeats: (BOOL)yesno;
- (NSTimeInterval)joystickPollInterval;
- (void)setWindowKey: (int)key;

	/* child management */
- (void)addSubWindow: (id <GLUTWindows>)subwindow;

	/* context */
- (void)makeCurrent;
- (void)makeNotCurrent;
- (void)swapBuffers;

	/* callbacks */
- (void)setKeyboardCallback: (GLUTKeyboardCallback)func isKeyDown: (BOOL)yesno;
- (void)setMouseCallback: (GLUTMouseCallback)func;
- (void)setMotionCallback: (GLUTMotionCallback)func;
- (void)setPassiveMotionCallback: (GLUTMotionCallback)func;
- (void)setEntryCallback: (GLUTEntryCallback)func;
- (void)setSpecialCallback: (GLUTSpecialCallback)func isKeyDown: (BOOL)yesno;
- (void)setDisplayCallback: (GLUTDisplayCallback)func;
- (void)setReshapeCallback: (GLUTReshapeCallback)func;
- (void)setWindowStatusCallback: (GLUTWindowStatusCallback)func;
- (void)setVisibilityCallback: (GLUTVisibilityCallback)func;
- (void)setSpaceballMotionCallback: (GLUTSpaceballMotionCallback)func;
- (void)setSpaceballRotateCallback: (GLUTSpaceballRotateCallback)func;
- (void)setSpaceballButtonCallback: (GLUTSpaceballButtonCallback)func;
- (void)setButtonBoxCallback: (GLUTButtonBoxCallback)func;
- (void)setDialCallback: (GLUTDialCallback)func;
- (void)setTabletMotionCallback: (GLUTTabletMotionCallback)func;
- (void)setTabletButtonCallback: (GLUTTabletButtonCallback)func;
- (void)setJoystickCallback: (GLUTJoystickCallback)func pollInterval: (NSTimeInterval)delay;

	/* cursor */
- (void)setCursor: (int)crsrnum;
- (int)cursor;

		/* overlay management */
- (void)establishOverlay;
- (void)removeOverlay;
- (void)setUsesLayer: (GLenum)layer;

		/* window update state */
- (void)setNeedsStateUpdate: (BOOL)yesno;
- (BOOL)needsStateUpdate;

		/* defered operations */
- (void)postRedisplay;
- (void)setPosition: (NSPoint)position;
- (void)setSize: (NSSize)size;
- (void)push;
- (void)pop;
- (void)show;
- (void)hide;
- (void)updateWindowState;

		/* window status handling */
- (int)determineWindowStatusIgnoringSiblings: (BOOL)ignoreSiblings;
- (void)updateWindowStatus: (int)state;
- (int)windowStatus;

@end


/* *** globals *** */


extern int							__glutArgc;
extern char **						__glutArgv;
extern char *						__glutGeometry;
extern int							__glutScreenHeight;
extern int							__glutScreenWidth;
extern BOOL							__glutIconic;
extern BOOL							__glutDebug;
extern unsigned int				__glutDisplayMode;
extern char *						__glutDisplayString;
extern int							__glutInitWidth;
extern int							__glutInitHeight;
extern int							__glutInitX;
extern int							__glutInitY;
extern NSMapTable *				__glutWindowList;				/* list of GLUT top-level & sub- windows */
extern id<GLUTWindows>			__glutCurrentWindow;			/* current GLUT window */
extern int							__glutGameModeWindow;
extern NSMapTable *				__glutMenuList;
extern GLUTMenu *					__glutCurrentMenu;
extern GLUTMenuStatusCallback	__glutMenuStatusCallback;
extern GLUTIdleCallback			__glutIdleCallback;
extern GLUTTimerCallback		__glutTimerCallback;
extern int							__glutTimerValue;
extern BOOL							__glutFinishedInitialization;
extern NSTimeInterval			__glutPeriodicEventDelay;
extern int							__glutWindowUniqueID;
extern int							__glutMenuUniqueID;
extern BOOL							__glutMenuMode;
extern BOOL							__glutGameMode;
extern NSTimer *					__glutPeriodicObject;
extern BOOL							__glutEmulateMultiButtonMouse;


/* *** macros *** */

#define	FailNil(x)	if((x) == nil) goto _failed

#define	FWLocalizedString(key)	[[NSBundle bundleForClass: [GLUTApplication class]] localizedStringForKey: (key) value: nil table: nil]
