
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTMenu.h"
#import "GLUTView.h"
#import "GLUTVisual.h"








/* ***************** GLUT API *************** */


int glutGet(GLenum param)
{
	id<GLUTWindows>	win;
	GLint					val = 0;
	GLboolean			state = GL_FALSE;
	
	switch(param)
	{
		case GLUT_INIT_WINDOW_X:
			return __glutInitX;
		case GLUT_INIT_WINDOW_Y:
			return __glutInitY;
		case GLUT_INIT_WINDOW_WIDTH:
			return __glutInitWidth;
		case GLUT_INIT_WINDOW_HEIGHT:
			return __glutInitHeight;
		case GLUT_INIT_DISPLAY_MODE:
			return __glutDisplayMode;
		case GLUT_WINDOW_X:
			return (int) [__glutCurrentWindow windowPositionRelativeToParent: NO].x;
		case GLUT_WINDOW_Y:
			return (int) [__glutCurrentWindow windowPositionRelativeToParent: NO].y;
		case GLUT_WINDOW_WIDTH:
			return (int) [__glutCurrentWindow windowSize].width;
		case GLUT_WINDOW_HEIGHT:
			return (int) [__glutCurrentWindow windowSize].height;
		case GLUT_WINDOW_BUFFER_SIZE:
			{
				GLboolean	isIndexed = GL_FALSE;
				int			bpp = 0;
				
				glGetBooleanv(GL_INDEX_MODE, &isIndexed);
				if(isIndexed == GL_FALSE)
				{
					glGetIntegerv(GL_RED_BITS, &val);
					bpp = (int) val;
					glGetIntegerv(GL_GREEN_BITS, &val);
					bpp += (int) val;
					glGetIntegerv(GL_BLUE_BITS, &val);
					bpp += (int) val;
					glGetIntegerv(GL_ALPHA_BITS, &val);
					bpp += (int) val;
				}
				else
				{
					glGetIntegerv(GL_INDEX_BITS, &val);
					bpp = (int) val;
				}
			
				return bpp;
			}
		case GLUT_WINDOW_STENCIL_SIZE:
			glGetIntegerv(GL_STENCIL_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_DEPTH_SIZE:
			glGetIntegerv(GL_DEPTH_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_RED_SIZE:
			glGetIntegerv(GL_RED_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_GREEN_SIZE:
			glGetIntegerv(GL_GREEN_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_BLUE_SIZE:
			glGetIntegerv(GL_BLUE_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_ALPHA_SIZE:
			glGetIntegerv(GL_ALPHA_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_ACCUM_RED_SIZE:
			glGetIntegerv(GL_ACCUM_RED_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_ACCUM_GREEN_SIZE:
			glGetIntegerv(GL_ACCUM_GREEN_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_ACCUM_BLUE_SIZE:
			glGetIntegerv(GL_ACCUM_BLUE_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_ACCUM_ALPHA_SIZE:
			glGetIntegerv(GL_ACCUM_ALPHA_BITS, &val);
			return (int) val;
		case GLUT_WINDOW_DOUBLEBUFFER:
			glGetBooleanv(GL_DOUBLEBUFFER, &state);
			return (int) state;
		case GLUT_WINDOW_RGBA:
			glGetBooleanv(GL_RGBA_MODE, &state);
			return (int) state;
		case GLUT_WINDOW_COLORMAP_SIZE:
			return 0;
		case GLUT_WINDOW_PARENT:
		{
			win = [__glutCurrentWindow parentWindow];
			{
				NSMapEnumerator	enumerator = NSEnumerateMapTable(__glutWindowList);
				int					key = 0;
				id<GLUTWindows>	window = nil;
				
				while(NSNextMapEnumeratorPair(&enumerator, (void *) &key, (void *) &window) == YES)
				{
					if(window == win)
						return key;
				}
			}
			return 0;
		}
		case GLUT_WINDOW_NUM_CHILDREN:
			return [__glutCurrentWindow numberOfSubWindows];
		case GLUT_WINDOW_NUM_SAMPLES:
			return 0;
		case GLUT_WINDOW_STEREO:
			glGetBooleanv(GL_STEREO, &state);
			return (int) state;
		case GLUT_WINDOW_CURSOR:
			return [__glutCurrentWindow cursor];
		case GLUT_SCREEN_WIDTH:
			return __glutScreenWidth;
		case GLUT_SCREEN_HEIGHT:
			return __glutScreenHeight;
		case GLUT_SCREEN_WIDTH_MM:
			return (int) ((float) __glutScreenWidth / 3.53);
		case GLUT_SCREEN_HEIGHT_MM:
			return (int) ((float) __glutScreenHeight / 3.53);
		case GLUT_MENU_NUM_ITEMS:
			return [__glutCurrentMenu numberOfItems];
		case GLUT_DISPLAY_MODE_POSSIBLE:
			return [GLUTView canCreateInstanceWithString: __glutDisplayString];
		case GLUT_ELAPSED_TIME:
			{
				struct timeval	elapsed, beginning, now;
				
				__glutInitTime(&beginning);
				gettimeofday(&now, (struct timezone *) NULL);
				timersub(&now, &beginning, &elapsed);
					/* Return elapsed milliseconds. */
				return (int) ((elapsed.tv_sec * 1000) + (elapsed.tv_usec / 1000));
			}
		case GLUT_WINDOW_FORMAT_ID:
			return [[__glutCurrentWindow visual] visualInfoID];
		default:
			__glutWarning("invalid glutGet parameter: %d", param);
			return -1;
	}
}

int glutLayerGet(GLenum param)
{
	switch(param)
	{
		case GLUT_OVERLAY_POSSIBLE:
			return 0;
		case GLUT_LAYER_IN_USE:
			return GLUT_NORMAL;
		case GLUT_HAS_OVERLAY:
			return 0;
		case GLUT_TRANSPARENT_INDEX:
			return -1;
		case GLUT_NORMAL_DAMAGED:
			return [__glutCurrentWindow isDamaged];
		case GLUT_OVERLAY_DAMAGED:
			return -1;
		default:
			__glutWarning("invalid glutLayerGet parameter: %d", param);
			return -1;		
	}
}

int glutDeviceGet(GLenum param)
{
	switch(param)
	{
		case GLUT_HAS_KEYBOARD:
		case GLUT_HAS_MOUSE:
			return 1;
		case GLUT_NUM_MOUSE_BUTTONS:
			return 1;
		case GLUT_HAS_SPACEBALL:
		case GLUT_HAS_DIAL_AND_BUTTON_BOX:
		case GLUT_HAS_TABLET:
		case GLUT_HAS_JOYSTICK:
		case GLUT_NUM_SPACEBALL_BUTTONS:
		case GLUT_NUM_BUTTON_BOX_BUTTONS:
		case GLUT_NUM_DIALS:
		case GLUT_NUM_TABLET_BUTTONS:
		case GLUT_JOYSTICK_BUTTONS:
		case GLUT_JOYSTICK_AXES:
			return 0;
		case GLUT_DEVICE_IGNORE_KEY_REPEAT:
			return [__glutCurrentWindow ignoreKeyRepeats];
		case GLUT_DEVICE_KEY_REPEAT:
			return GLUT_KEY_REPEAT_ON;
		case GLUT_JOYSTICK_POLL_RATE:
			return (int)([__glutCurrentWindow joystickPollInterval] * 1000.0);
		default:
			__glutWarning("invalid glutDeviceGet parameter: %d", param);
			return -1;
	}
}

int glutGetModifiers(void)
{
	return [__glutCurrentWindow modifierFlags];
}
