
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTWindow.h"
#import "GLUTView.h"
#import "GLUTMenu.h"
#import "GLUTOverlay.h"
#import "GLUTApplication.h"






/* ***************** GLUT API *************** */



/* *** windows *** */


int APIENTRY glutCreateWindow(const char *name)
{
	GLUTWindow *	win = nil;
	NSString *		windowTitle = nil;
	
	if(name != NULL)
		windowTitle = [NSString stringWithCString: name];
	else
		windowTitle = [[NSProcessInfo processInfo] processName];
	
	win = [[GLUTWindow alloc] initWithTitle: windowTitle displayString: __glutDisplayString gameMode: NO];
	if(win == nil)
		__glutFatalError("out of memory.");
	
	NSMapInsertKnownAbsent(__glutWindowList, (void *) ++__glutWindowUniqueID, win);
	[win setWindowKey: __glutWindowUniqueID];
	[win release];

	[win makeCurrent];	

	return __glutWindowUniqueID;
}

int APIENTRY glutCreateSubWindow(int win, int x, int y, int width, int height)
{
	id<GLUTWindows>	parentWindow = nil;
	GLUTView *			subWindow = nil;
	NSRect				viewRect;
	
	viewRect.origin.x		= fabs((float) x);
	viewRect.origin.y		= fabs((float) y);
	viewRect.size.width	= fabs((float) width);
	viewRect.size.height	= fabs((float) height);
	
	subWindow = [[GLUTView alloc] initWithFrame: viewRect displayString: __glutDisplayString isSubWindow: YES];
	if(subWindow == nil)
		__glutFatalError("out of memory.");
	
	parentWindow = (id<GLUTWindows>) NSMapGet(__glutWindowList, (void *) win);
	[parentWindow addSubWindow: subWindow];
	NSMapInsertKnownAbsent(__glutWindowList, (void *) ++__glutWindowUniqueID, subWindow);
	[subWindow setWindowKey: __glutWindowUniqueID];
	[subWindow release];
	
	[subWindow makeCurrent];
	return __glutWindowUniqueID;
}

void APIENTRY glutSetWindow(int win)
{
	if(win < 1 || win > __glutWindowUniqueID)
	{
		__glutWarning("glutSetWindow attempted on bogus window %d.", win);
		return;
	}
	
	{
		id<GLUTWindows>	window = (id<GLUTWindows>) NSMapGet(__glutWindowList, (void *) win);
		
		[window makeCurrent];
	}
}

int APIENTRY glutGetWindow(void)
{
	if(__glutCurrentWindow)
	{
		NSMapEnumerator	enumerator = NSEnumerateMapTable(__glutWindowList);
		int					key = 0;
		id<GLUTWindows>	window = nil;
		
		while(NSNextMapEnumeratorPair(&enumerator, (void *) &key, (void *) &window) == YES)
		{
			if(window == __glutCurrentWindow)
				return key;
		}
	}
	return 0;
}

void APIENTRY glutDestroyWindow(int win)
{
	if(win < 1 || win > __glutWindowUniqueID)
	{
		__glutWarning("glutDestroyWindow attempted on bogus window %d.", win);
		return;
	}
	
			/* recursively destroys all childrens and unbinds GL */
	{
		id<GLUTWindows>	window = NSMapGet(__glutWindowList, (void *) win);
		
			/* remove the window from the window update list */
		[NSApp unmarkWindowAsNeedingUpdate: window];

		if([window isKindOfClass: [GLUTView class]])
			[((GLUTView *) window) removeFromParent];
		NSMapRemove(__glutWindowList, (void *) win);
	}
}

void APIENTRY glutSetWindowTitle(const char *name)
{
	if((__glutGameMode == NO) && ([__glutCurrentWindow isMemberOfClass: [GLUTWindow class]] == YES))
		[((GLUTWindow *) __glutCurrentWindow) setTitle: [NSString stringWithCString: name]];
}

void APIENTRY glutSetIconTitle(const char *name)
{
	if((__glutGameMode == NO) && ([__glutCurrentWindow isMemberOfClass: [GLUTWindow class]] == YES))
		[((GLUTWindow *) __glutCurrentWindow) setIconTitle: [NSString stringWithCString: name]]; 
}

void APIENTRY glutPostRedisplay(void)
{
	[__glutCurrentWindow postRedisplay];
}

void APIENTRY glutPostWindowRedisplay(int win)
{
	id<GLUTWindows>	window = (id<GLUTWindows>) NSMapGet(__glutWindowList, (void *) win);
	
	[window postRedisplay];
}

void APIENTRY glutPositionWindow(int x, int y)
{
	if(__glutGameMode == NO)
		[__glutCurrentWindow setPosition: NSMakePoint((float) x, (float) y)];
}

void APIENTRY glutReshapeWindow(int width, int height)
{
	if(__glutGameMode == NO)
	{
		if(width <= 0 || height <= 0)
			__glutWarning("glutReshapeWindow: non-positive width or height not allowed");
		
		[__glutCurrentWindow setSize: NSMakeSize((float) width, (float) height)];
	}
}

void APIENTRY glutFullScreen(void)
{
	if((__glutGameMode == NO) && ([__glutCurrentWindow isMemberOfClass: [GLUTWindow class]] == YES))
		[((GLUTWindow *) __glutCurrentWindow) setToFullScreen];
}

void APIENTRY glutPopWindow(void)
{
	if(__glutGameMode == NO)
		[__glutCurrentWindow pop];
}

void APIENTRY glutPushWindow(void)
{
	if(__glutGameMode == NO)
		[__glutCurrentWindow push];
}

void APIENTRY glutShowWindow(void)
{
	if(__glutGameMode == NO)
		[__glutCurrentWindow show];
}

void APIENTRY glutHideWindow(void)
{
	if(__glutGameMode == NO)
		[__glutCurrentWindow hide];
}

void APIENTRY glutIconifyWindow(void)
{
	if((__glutGameMode == NO) && ([__glutCurrentWindow isMemberOfClass: [GLUTWindow class]] == YES))
		[((GLUTWindow *) __glutCurrentWindow) iconify];
}


/* *** events *** */


void APIENTRY glutMainLoop(void)
{	
	[NSApp run];
}

void APIENTRY glutKeyboardFunc(void (*func)(unsigned char key, int x, int y))
{
	[__glutCurrentWindow setKeyboardCallback: (GLUTKeyboardCallback) func isKeyDown: YES];
}

void APIENTRY glutMouseFunc(void (*func)(int button, int state, int x, int y))
{
	[__glutCurrentWindow setMouseCallback: (GLUTMouseCallback) func];
}

void APIENTRY glutMotionFunc(void (*func)(int x, int y))
{
	[__glutCurrentWindow setMotionCallback: (GLUTMotionCallback) func];
}

void APIENTRY glutPassiveMotionFunc(void (*func)(int x, int y))
{
	[__glutCurrentWindow setPassiveMotionCallback: (GLUTMotionCallback) func];
}

void APIENTRY glutEntryFunc(void (*func)(int state))
{
	[__glutCurrentWindow setEntryCallback: (GLUTEntryCallback) func];
}

void APIENTRY glutSpecialFunc(void (*func)(int key, int x, int y))
{
	[__glutCurrentWindow setSpecialCallback: (GLUTSpecialCallback) func isKeyDown: YES];
}

void APIENTRY glutSpaceballMotionFunc(void (*func)(int x, int y, int z))
{
	[__glutCurrentWindow setSpaceballMotionCallback: (GLUTSpaceballMotionCallback) func];
}

void APIENTRY glutSpaceballRotateFunc(void (*func)(int x, int y, int z))
{
	[__glutCurrentWindow setSpaceballRotateCallback: (GLUTSpaceballRotateCallback) func];
}

void APIENTRY glutSpaceballButtonFunc(void (*func)(int button, int state))
{
	[__glutCurrentWindow setSpaceballButtonCallback: (GLUTSpaceballButtonCallback) func];
}

void APIENTRY glutButtonBoxFunc(void (*func)(int button, int state))
{
	[__glutCurrentWindow setButtonBoxCallback: (GLUTButtonBoxCallback) func];
}

void APIENTRY glutDialsFunc(void (*func)(int dial, int value))
{
	[__glutCurrentWindow setDialCallback: (GLUTDialCallback) func];
}

void APIENTRY glutTabletMotionFunc(void (*func)(int x, int y))
{
	[__glutCurrentWindow setTabletMotionCallback: (GLUTTabletMotionCallback) func];
}

void APIENTRY glutTabletButtonFunc(void (*func)(int button, int state, int x, int y))
{
	[__glutCurrentWindow setTabletButtonCallback: (GLUTTabletButtonCallback) func];
}

void APIENTRY glutKeyboardUpFunc(void (*func)(unsigned char key, int x, int y))
{
	[__glutCurrentWindow setKeyboardCallback: (GLUTKeyboardCallback) func isKeyDown: NO];
}

void APIENTRY glutSpecialUpFunc(void (*func)(int key, int x, int y))
{
	[__glutCurrentWindow setSpecialCallback: (GLUTSpecialCallback) func isKeyDown: NO];
}

void APIENTRY glutJoystickFunc(void (*func)(unsigned int buttonMask, int x, int y, int z), int pollInterval)
{
	[__glutCurrentWindow setJoystickCallback: (GLUTJoystickCallback) func pollInterval: (NSTimeInterval) pollInterval / 1000.0];
}

void APIENTRY glutForceJoystickFunc(void)
{
	/* unimplemented */
}

void APIENTRY glutIgnoreKeyRepeat(int ignore)
{
	[__glutCurrentWindow setIgnoreKeyRepeats: (ignore != 0) ? YES : NO];
}

void APIENTRY glutSetKeyRepeat(int repeatMode)
{
	/* unimplemented */
}

void APIENTRY glutVisibilityFunc(void (*func)(int state))
{
	[__glutCurrentWindow setVisibilityCallback: (GLUTVisibilityCallback) func];
}

void APIENTRY glutWindowStatusFunc(void (*func)(int state))
{
	[__glutCurrentWindow setWindowStatusCallback: (GLUTWindowStatusCallback) func];
}

void APIENTRY glutDisplayFunc(void (*func)(void))
{
	if(!func)
		__glutFatalError("NULL display callback not allowed in GLUT 3.0; update your code.");

	[__glutCurrentWindow setDisplayCallback: func];
}

void APIENTRY glutReshapeFunc(void (*func)(int width, int height))
{
	[__glutCurrentWindow setReshapeCallback: (GLUTReshapeCallback) func];
}


/* *** overlays *** */


void APIENTRY glutEstablishOverlay(void)
{
	[__glutCurrentWindow establishOverlay];
}

void APIENTRY glutUseLayer(GLenum layer)
{
	if(layer != GLUT_NORMAL || layer != GLUT_OVERLAY)
		__glutWarning("glutUseLayer: unknown layer, %d.", layer);

	[__glutCurrentWindow setUsesLayer: layer];
}

void APIENTRY glutRemoveOverlay(void)
{
	[__glutCurrentWindow removeOverlay];
}

void APIENTRY glutPostOverlayRedisplay(void)
{
	[[__glutCurrentWindow overlay] display];
}

void APIENTRY glutPostWindowOverlayRedisplay(int win)
{
	if(win < 1 || win > __glutWindowUniqueID)
	{
		__glutWarning("glutPostWindowOverlayRedisplay attempted on bogus window %d.", win);
		return;
	}
	
	{
		id<GLUTWindows>	window = (id<GLUTWindows>) NSMapGet(__glutWindowList, (void *) win);
		
		[[window overlay] display];
	}
}

void APIENTRY glutShowOverlay(void)
{
	[[__glutCurrentWindow overlay] show];
}

void APIENTRY glutHideOverlay(void)
{
	[[__glutCurrentWindow overlay] hide];
}

void APIENTRY glutOverlayDisplayFunc(void (*func)(void))
{
	[[__glutCurrentWindow overlay] setDisplayCallback: (GLUTDisplayCallback) func];
}


/* *** menus *** */


int APIENTRY glutCreateMenu(void (*func) (int value))
{
	GLUTMenu *	menu = [[GLUTMenu alloc] initWithCallback: (GLUTMenuCallback) func];
	
	if(menu == nil)
		__glutFatalError("out of memory.");
	
	NSMapInsertKnownAbsent(__glutMenuList, (void *) ++__glutMenuUniqueID, menu);
	[menu release];
	
	[menu makeCurrent];
	return __glutMenuUniqueID;
}

void APIENTRY glutSetMenu(int menu)
{
	if(menu < 1 || menu > __glutMenuUniqueID)
	{
		__glutWarning("glutSetMenu attempted on bogus menu %d.", menu);
		return;
	}
	
	{
		GLUTMenu *	menuObj = (GLUTMenu *) NSMapGet(__glutMenuList, (void *) menu);
		
		[menuObj makeCurrent];
	}
}

int APIENTRY glutGetMenu(void)
{
	if(__glutCurrentMenu)
	{
		NSMapEnumerator	enumerator = NSEnumerateMapTable(__glutMenuList);
		int					key = 0;
		GLUTMenu *			menu = nil;
		
		while(NSNextMapEnumeratorPair(&enumerator, (void *) &key, (void *) &menu) == YES)
		{
			if(menu == __glutCurrentMenu)
				return key;
		}
	}
	return 0;
}

void APIENTRY glutDestroyMenu(int menu)
{
	if(menu < 1 || menu > __glutMenuUniqueID)
	{
		__glutWarning("glutDestroyMenu attempted on bogus menu %d.", menu);
		return;
	}
	
	if(__glutMenuMode == NO)
	{
		GLUTMenu *	menuObj = (GLUTMenu *) NSMapGet(__glutMenuList, (void *) menu);
		
		NSMapRemove(__glutMenuList, (void *) menu);
		if(menuObj == __glutCurrentMenu)
			__glutCurrentMenu = nil;
	}
}

void APIENTRY glutAddMenuEntry(const char *name, int value)
{
	if(name == NULL)
		__glutFatalError("glutAddMenuEntry called with NULL name.");
	
	if(__glutMenuMode == NO)
		[__glutCurrentMenu addMenuItemWithTitle: [NSString stringWithCString: name] tag: value];
}

void APIENTRY glutAddSubMenu(const char *name, int menu)
{
	if(name == NULL)
		__glutFatalError("glutAddSubMenu called with NULL name.");
	
	if(__glutMenuMode == NO)
	{
		GLUTMenu *	menuObj = (GLUTMenu *) NSMapGet(__glutMenuList, (void *) menu);
		
		[__glutCurrentMenu	addSubMenuWithTitle: [NSString stringWithCString: name] menu: menuObj];
	}
}

void APIENTRY glutChangeToMenuEntry(int entry, const char *name, int value)
{
	if(name == NULL)
		__glutFatalError("glutChangeToMenuEntry called with NULL name.");

	[__glutCurrentMenu	setMenuItemAtIndex: entry - 1
								toTitle: [NSString stringWithCString: name]
								tag: value];
}

void APIENTRY glutChangeToSubMenu(int entry, const char *name, int menu)
{
	if(name == NULL)
		__glutFatalError("glutChangeToSubMenu called with NULL name.");
	
	{
		GLUTMenu *	menuObj = (GLUTMenu *) NSMapGet(__glutMenuList, (void *) menu);
		
		[__glutCurrentMenu	setMenuItemAtIndex: entry - 1
									toTitle: [NSString stringWithCString: name]
									menu: menuObj];
	}
}

void APIENTRY glutRemoveMenuItem(int entry)
{
	if(__glutMenuMode == NO)
		[__glutCurrentMenu removeMenuItemAtIndex: entry - 1];
}

void APIENTRY glutAttachMenu(int button)
{
	if(__glutMenuMode == NO && __glutGameMode == NO)
		[__glutCurrentMenu attachToMouseButton: button];
}

void APIENTRY glutDetachMenu(int button)
{
	if(__glutMenuMode == NO)
		[__glutCurrentMenu detachFromMouseButton: button];
}

void APIENTRY glutMenuStatusFunc(void (*func)(int status, int x, int y))
{
	__glutMenuStatusCallback = (GLUTMenuStatusCallback) func;
}

void APIENTRY glutMenuStateFunc(void (*func)(int status))
{
	__glutMenuStatusCallback = (GLUTMenuStatusCallback) func;
}


/* *** misc ** */


void APIENTRY glutSetCursor(int cursor)
{
	[__glutCurrentWindow setCursor: cursor];
}

void APIENTRY glutSwapBuffers(void)
{
	[__glutCurrentWindow swapBuffers];
}

void APIENTRY glutIdleFunc(void (*func)(void))
{
	__glutIdleCallback = (GLUTIdleCallback) func;
		// setup periodic event generation
	if(func)
	{
/*		[__glutPeriodicObject invalidate];
		__glutPeriodicObject = [NSTimer	scheduledTimerWithTimeInterval: __glutPeriodicEventDelay
													target: NSApp
													selector: @selector(periodicAction)
													userInfo: nil
													repeats: YES];
*/
		[NSObject cancelPreviousPerformRequestsWithTarget: NSApp selector: @selector(periodicAction:) object: nil]; 
		[NSApp performSelector: @selector(periodicAction:) withObject: nil afterDelay: __glutPeriodicEventDelay];
	}
	else
	{
//		[__glutPeriodicObject invalidate];
		[NSObject cancelPreviousPerformRequestsWithTarget: NSApp selector: @selector(periodicAction:) object: nil]; 
		__glutPeriodicObject = nil;
	}
}

void APIENTRY glutTimerFunc(unsigned int msecs, void (*func)(int value), int value)
{
	if(func)
	{
		NSTimeInterval	ti = msecs / 1000;
		
		__glutTimerCallback = func;
		__glutTimerValue = value;

		(void) [NSTimer	scheduledTimerWithTimeInterval: ti
								target: NSApp
								selector: @selector(timerAction)
								userInfo: nil
								repeats: NO];
	}
}
