
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


#import <AppKit/AppKit.h>
#import "macxglut_private.h"


#define	GLUT_UNKNOWN_VISIBILITY		GLUT_FULLY_COVERED + 1




/* *** types *** */

/* *** GLUT view class *** */

@class	GLUTVisual, GLUTOverlay;


@interface GLUTView : NSView <GLUTWindows>
{
@private
	
	GLUTVisual *						_visual;						/* interface to OpenGL client lib */
	GLUTOverlay *						_overlay;
	NSCursor *							_cursorObj;
	
	GLUTKeyboardCallback				_keyboardCallback;
	GLUTKeyboardCallback				_keyUpCallback;
	GLUTMouseCallback					_mouseCallback;
	GLUTMotionCallback				_motionCallback;
	GLUTMotionCallback				_passiveMotionCallback;
	GLUTEntryCallback					_entryCallback;
	GLUTSpecialCallback				_specialCallback;
	GLUTSpecialCallback				_specialUpCallback;
	GLUTDisplayCallback				_displayCallback;
	GLUTReshapeCallback				_reshapeCallback;
	GLUTWindowStatusCallback		_windowStatusCallback;
	GLUTVisibilityCallback			_visibilityCallback;
	
	GLUTSpaceballMotionCallback	_spaceballMotionCallback;
	GLUTSpaceballRotateCallback	_spaceballRotateCallback;
	GLUTSpaceballButtonCallback	_spaceballButtonCallback;
	GLUTButtonBoxCallback			_buttonBoxCallback;
	GLUTDialCallback					_dialCallback;
	GLUTTabletMotionCallback		_tabletMotionCallback;
	GLUTTabletButtonCallback		_tabletButtonCallback;
	GLUTJoystickCallback				_joystickCallback;
	
	struct __vFlags {
		unsigned int						isSubWindow				: 1;
		unsigned int						drawToOverlay			: 1;
		unsigned int						pendingShowHide		: 1;
		unsigned int						doShowOp					: 1;
		unsigned int						pendingPushPop			: 1;
		unsigned int						doPushOp					: 1;
		unsigned int						pendingRedisplay		: 1;
		unsigned int						pendingMove				: 1;
		unsigned int						pendingReshape			: 1;
		unsigned int						forceReshapeCall		: 1;		// forces call of reshapeWithNewSize: after initialization in drawRect:
		unsigned int						isDamaged				: 1;
		unsigned int						modifierFlagsValid	: 1;
		unsigned int						ignoreKeyRepeats		: 1;
		unsigned int						cursor					: 8;
		unsigned int						needsUpdate				: 1;
		unsigned int						isDrawingLocked		: 1;
		unsigned int						reserved0				: 9;
	}										_flags;
	int									_windowStatus;
	int									_windowKey;
	int									_modifierFlags;
	NSTrackingRectTag					_trackingRectTag;
	NSTimeInterval						_pollInterval;
	NSPoint								_keyDownMouseLocation;
	NSPoint								_pos;
	NSSize								_size;
}

+ (BOOL)canCreateInstanceWithString: (const char *)dstring;


- (id)initWithFrame: (NSRect)frameRect displayString: (const char *)displayString isSubWindow: (BOOL)yesno;
- (void)dealloc;

		/* accessors */
- (GLUTVisual *)visual;
- (GLUTOverlay *)overlay;
- (NSPoint)windowPositionRelativeToParent: (BOOL)yesno;
- (NSSize)windowSize;
- (BOOL)isVisible;
- (BOOL)isSubWindow;
- (BOOL)isDamaged;
- (id <GLUTWindows>)parentWindow;
- (int)numberOfSubWindows;
- (NSWindow *)nativeWindow;
- (int)modifierFlags;
- (BOOL)ignoreKeyRepeats;
- (void)setIgnoreKeyRepeats: (BOOL)yesno;
- (NSTimeInterval)joystickPollInterval;
- (void)setWindowKey: (int)key;

		/* childs management */
- (void)addSubWindow: (id <GLUTWindows>)subwindow;
- (void)removeFromParent;

		/* context */
- (void)makeCurrent;
- (void)makeNotCurrent;
- (void)swapBuffers;
#if defined(GFXLIB_MESA26)
- (void)flushGraphics;
#endif

- (void)show;
- (void)hide;

		/* callbacks */
- (void)setKeyboardCallback: (GLUTKeyboardCallback)func isKeyDown: (BOOL)yesno;
- (void)setMouseCallback: (GLUTMouseCallback)func;
- (void)setMotionCallback: (GLUTMotionCallback)func;
- (void)setPassiveMotionCallback: (GLUTMotionCallback)func;
- (void)setEntryCallback: (GLUTEntryCallback)func;
- (void)setSpecialCallback: (GLUTSpecialCallback)func isKeyDown: (BOOL)yesno;
- (void)setDisplayCallback: (GLUTDisplayCallback)func;
- (void)setReshapeCallback: (GLUTReshapeCallback)func;
- (void)setWindowStatusCallback: (GLUTWindowStatusCallback)func;
- (void)setVisibilityCallback: (GLUTVisibilityCallback)func;
- (void)setSpaceballMotionCallback: (GLUTSpaceballMotionCallback)func;
- (void)setSpaceballRotateCallback: (GLUTSpaceballRotateCallback)func;
- (void)setSpaceballButtonCallback: (GLUTSpaceballButtonCallback)func;
- (void)setButtonBoxCallback: (GLUTButtonBoxCallback)func;
- (void)setDialCallback: (GLUTDialCallback)func;
- (void)setTabletMotionCallback: (GLUTTabletMotionCallback)func;
- (void)setTabletButtonCallback: (GLUTTabletButtonCallback)func;
- (void)setJoystickCallback: (GLUTJoystickCallback)func pollInterval: (NSTimeInterval)delay;

		/* cursor */
- (void)setCursor: (int)crsrnum;
- (int)cursor;

		/* overlay management */
- (void)establishOverlay;
- (void)removeOverlay;
- (void)setUsesLayer: (GLenum)layer;

		/* window update state */
- (void)setNeedsStateUpdate: (BOOL)yesno;
- (BOOL)needsStateUpdate;

		/* defered operations */
- (void)postRedisplay;
- (void)setPosition: (NSPoint)position;
- (void)setSize: (NSSize)size;
- (void)show;
- (void)hide;
- (void)push;
- (void)pop;
- (void)updateWindowState;
	
		/* window status management */
- (int)determineWindowStatusIgnoringSiblings: (BOOL)ignoreSiblings;
- (void)updateWindowStatus: (int)state;
- (int)windowStatus;

@end
