
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTApplication.h"
#import "GLUTWindow.h"
#import "GLUTView.h"
#import "GLUTMenu.h"



extern GLUTMenu *					__glutLeftButtonMenu;
extern GLUTMenu *					__glutMiddleButtonMenu;
extern GLUTMenu *					__glutRightButtonMenu;







/* ***************** GLUTApplication class implementation ******************** */


@implementation GLUTApplication


- (id)init
{
	if((self = [super init]) != nil)
	{
		_windowsNeedingUpdate = [[NSMutableArray alloc] initWithCapacity: 2];
		if(_windowsNeedingUpdate == nil)
			goto _failed;

		[self setDelegate: self];
		return self;
	}

_failed:
	
	[self release];
	return nil;
}

- (void)dealloc
{
	[_windowsNeedingUpdate release];
	[super dealloc];
}

- (void)timerAction
{
//	NSLog(@"timerAction begin\n");
	(*__glutTimerCallback)(__glutTimerValue);
	
	if(__glutDebug)
		glutReportErrors();
	
	[self updateWindowStatesIfNeeded];
//	NSLog(@"timerAction end\n");
}

- (void)periodicAction:(id)unused
{
		// ugly hack necessary simply because some people draw inside the periodic callback,
		// which is a very bad idea, really.
	if([__glutCurrentWindow isMemberOfClass: [GLUTView class]] == YES)
	{
		[((GLUTView *) __glutCurrentWindow) lockFocus];
			(*__glutIdleCallback)();
			glFlush();
#if defined(GFXLIB_MESA26)
			[((GLUTView *) __glutCurrentWindow) flushGraphics];
#endif
		[((GLUTView *) __glutCurrentWindow) unlockFocus];
	}
	else
	{
		[[((GLUTWindow *) __glutCurrentWindow) contentView] lockFocus];	
			(*__glutIdleCallback)();
			glFlush();
#if defined(GFXLIB_MESA26)
			[[((GLUTWindow *) __glutCurrentWindow) contentView] flushGraphics];
#endif
		[[((GLUTWindow *) __glutCurrentWindow) contentView] unlockFocus];
	}
	
	if(__glutDebug)
		glutReportErrors();
	
	[self updateWindowStatesIfNeeded];
	[NSApp performSelector: @selector(periodicAction:) withObject: nil afterDelay: __glutPeriodicEventDelay];
}

- (NSEvent *)nextEventMatchingMask:(unsigned int)mask untilDate:(NSDate *)expiration inMode:(NSString *)mode dequeue:(BOOL)deqFlag
{
//	NSLog(@"nextEventMatchingMask begin\n");
	[self updateWindowStatesIfNeeded];
//	NSLog(@"nextEventMatchingMask end\n");
	return [super nextEventMatchingMask: mask untilDate: expiration inMode: mode dequeue: deqFlag];
}

	/* If the given GLUTWindow isn't yet on the update list, put it there.
		Make sure that when we iterate over the array GLUTWindow instance will be seen before GLUTView
		instances. This is necessary so that the top level windows will be displayed before there sub-
		windows. */
- (void)markWindowAsNeedingUpdate: (id<GLUTWindows>)aWindow
{
	if([_windowsNeedingUpdate containsObject: aWindow] == NO)
	{
		if([aWindow isSubWindow] == NO)
			[_windowsNeedingUpdate insertObject: aWindow atIndex: 0];
		else
			[_windowsNeedingUpdate addObject: aWindow];
	}
	_windowsNeedUpdate = YES;
}

- (void)unmarkWindowAsNeedingUpdate: (id<GLUTWindows>)aWindow
{
	if([_windowsNeedingUpdate containsObject: aWindow] == YES)
		[_windowsNeedingUpdate removeObject: aWindow];
}

	/* Give every window and it's subwindows a chance to update it's state. Returns YES if
		all windows were completly update, NO if there are still some windows left which
		need further updates. */
- (BOOL)updateWindowStatesIfNeeded
{
//	NSLog(@"updateWindowStatesIfNeeded begin\n");
	if(_windowsNeedUpdate == YES)
	{
		id<GLUTWindows>	actWindow = nil;
		register unsigned	i, count = [_windowsNeedingUpdate count];
		
		for(i = 0; i < count; i++)
		{
			id<GLUTWindows>	win = [_windowsNeedingUpdate objectAtIndex: i];
			[win updateWindowState];
		}
			// remove all GLUT windows which are no longer marked as needing update
		i = 0;
		while(i < [_windowsNeedingUpdate count])
		{
			actWindow = [_windowsNeedingUpdate objectAtIndex: i];
			if([actWindow needsStateUpdate] == YES)
				i++;
			else
			{
				[_windowsNeedingUpdate removeObject: actWindow];
			}
		}
		
		if([_windowsNeedingUpdate count] == 0)
			_windowsNeedUpdate = NO;
	}
//	NSLog(@"updateWindowStatesIfNeeded end\n");

	return _windowsNeedUpdate;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
	NSPrintInfo *	sharedPrintInfo = [NSPrintInfo sharedPrintInfo];
	
	__glutFinishedInitialization = YES;
	
	[[NSNotificationCenter defaultCenter]	addObserver: self
														selector: @selector(menuWillSendAction:)
														name: NSMenuWillSendActionNotification
														object: nil];
	[[NSNotificationCenter defaultCenter]	addObserver: self
														selector: @selector(menuDidSendAction:)
														name: NSMenuDidSendActionNotification
														object: nil];
		
	if([NSBundle loadNibNamed: @"GLUT.nib" owner: self] == NO)
	{
		__glutFatalError("unable to load GLUT.nib");
		NSBeep();
		[self terminate: nil];
		return;
	}
	
		// ** add menus built by GLUT client to the main menu **
	[__glutLeftButtonMenu attachToMouseButton: GLUT_LEFT_BUTTON];
	[__glutMiddleButtonMenu attachToMouseButton: GLUT_MIDDLE_BUTTON];
	[__glutRightButtonMenu attachToMouseButton: GLUT_RIGHT_BUTTON];
	
		// ** setup shared print info **
	[sharedPrintInfo setHorizontalPagination: NSFitPagination];
	[sharedPrintInfo setVerticalPagination: NSFitPagination];
}

- (void)applicationWillTerminate:(NSNotification *)notification
{
	glutIdleFunc(NULL);
	[[NSNotificationCenter defaultCenter] removeObserver: self];
}

- (void)menuWillSendAction: (NSNotification *)notification
{
	__glutMenuMode = YES;
	if(__glutMenuStatusCallback)
		(*__glutMenuStatusCallback)(GLUT_MENU_IN_USE, 0, 0);
}

- (void)menuDidSendAction: (NSNotification *)notification
{
	if(__glutMenuStatusCallback)
		(*__glutMenuStatusCallback)(GLUT_MENU_NOT_IN_USE, 0, 0);
	__glutMenuMode = NO;
}

@end
