
/* Copyright (c) Planitzer Dietmar, 1998. */

/* This program is freely distributable without licensing fees
   and is provided without guarantee or warrantee expressed or
   implied. This program is -not- in the public domain. */

#import "GLUTAboutController.h"









/* *** class implementation *** */

@implementation GLUTAboutController

/* ** class methods ** */


/* ** instance methods ** */

- (id)init
{
	if((self = [super initWithWindowNibName: @"GLUTAbout"]) != nil)
	{
		[self setShouldCascadeWindows: NO];
		return self;
	}
	return nil;
}

- (void)windowDidLoad
{
	NSString *	platformName = nil;
	
	switch([[NSProcessInfo processInfo] operatingSystem])
	{
		case NSMACHOperatingSystem:
												platformName = @"Power Macintosh";
												break;
		case NSWindows95OperatingSystem:
												platformName = @"Windows 95";
												break;
		case NSWindowsNTOperatingSystem:
												platformName = @"Windows NT";
												break;
		default:
						platformName = @"";
						break;
	}
	[_platformTextField setStringValue: [NSString stringWithFormat: [_platformTextField stringValue], platformName]];
	[[self window] center];
}

@end
