/********************************************************************************

File:       PageLabApp.m

This implements the application's controller.  This object is a delegate of the
application and handles the custom page layout calls.

This sample is based on a NeXTSTEP sample written by Samuel Streeper. 


Written by: Timothy Carroll

Created:    Wed 15-Oct-1997

Copyright:  (c) 1991, 1997 by Apple Computer, Inc., all rights reserved.

Change History (most recent first):

You may incorporate this sample code into your applications without
restriction, though the sample code has been provided "AS IS" and the
responsibility for its operation is 100% yours.  However, what you are
not permitted to do is to redistribute the source as "DSC Sample Code"
after having made changes. If you're going to re-distribute the source,
we require that you make it clear in the source that the code was
descended from Apple Sample Code, but that you've made changes.
********************************************************************************/


#import "PageLabApp.h"
#import "CustomPageLayout.h"

@implementation PageLabApp

- (void) showAboutPanel: (id) sender
{
	if (aboutPanel == NULL)
	{
		if (![NSBundle loadNibNamed: @"AboutPageLab.nib" owner:self])
		{
			NSLog(@"Failed to load AboutPageLab.nib");
			NSBeep();
			return;
		}
	}

	[aboutPanel center];
	[aboutPanel makeKeyAndOrderFront:nil];
}

- (void) runPageLayout: (id) sender
{
	id panel;

	panel = [CustomPageLayout customLayout];
	[panel runModal];
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
	return YES;
}

@end
