/********************************************************************************

File:       CustomPrintInfo.h 

This is a subclass of the standard NSPrintInfo object.  An NSPrintInfo object
holds all of the information about a particular print job, and is handed off
to the NSPrintOperation when that object is created.  This subclass adds a flag
to the print record to allow the pagination method to be set by the user.

This sample is based on a NeXTSTEP 3.3 sample written by Samuel Streeper.


Written by: Timothy Carroll

Created:    Wed 15-Oct-1997

Copyright:  (c) 1991, 1997 by Apple Computer, Inc., all rights reserved.

Change History (most recent first):

You may incorporate this sample code into your applications without
restriction, though the sample code has been provided "AS IS" and the
responsibility for its operation is 100% yours.  However, what you are
not permitted to do is to redistribute the source as "DSC Sample Code"
after having made changes. If you're going to re-distribute the source,
we require that you make it clear in the source that the code was
descended from Apple Sample Code, but that you've made changes.
********************************************************************************/


#import <AppKit/AppKit.h>

// the Pagination numbers match the index in the radio button group on the CustomPageLayout

typedef enum Pagination
{
	kPaginationAuto = 0,
	kPaginationAutoWithHelp =1,
	kPaginationAppControlled =2
} Pagination;


@interface CustomPrintInfo : NSPrintInfo
{
}

- (Pagination) paginationMode;
- (id) setPaginationMode: (Pagination) mode;


@end
