/*

Starter.m
Robby
 Version 2.0
 Copyright (c) 1995 by Sean Luke
 Version 3.0 & OpenStep / Rhapsody port
 Copyright (c) 1998 by Jerome Genest
 Donated to the MiscKit
MiscKit Example

 Permission to use, copy, modify, and distribute this material
 for any purpose and without fee, under the restrictions as noted
 in the MiscKit copyright notice, is hereby granted, provided that
 the MiscKit copyright notice and this permission notice
 appear in all source copies, and that the authors names shall not
 be used in advertising or publicity pertaining to this
 material without the specific, prior written permission
 of the author.  SEAN O. LUKE AMD JEROME GENEST  MAKE NO REPRESENTATIONS
 ABOUT THE ACCURACY OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.
 IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

*/

#import "Starter.h"
#import <MiscAppKit/MiscAppIconAnimator.h>
#import <MiscSoundKit/MiscVolumeMeter.h>

@implementation Starter

/*
Starter is the main object of Robby.  It does four things, basically:

0) Registering the default behaviour in initialize (Input, meter displayed)
1) Init according to the user defaults in awakefromnib
2) Adjust the display and save the defaults according to user actions
3) Update the application icon when the meter or light (both located in an invisible window)
   was updated.


Modifications
January 1993:  Created original version of Robby
August 14, 1995:  Ported Robby to be a MiscKit example
January 1997 Rewritten when ported to Rhapsody/Openstep
		-Now makes use of the MiscIconAnimator class instead of the Applicaton Icon Category
		-Allow the choice to display either a volume light or a volume meter

*/

+ (void)initialize
{
	// Registering default behaviour 

    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSDictionary *appDefaults = [NSDictionary dictionaryWithObject:@"YES" forKey:@"Robby:Input"];
    NSDictionary *robDefaults = [NSDictionary dictionaryWithObject:@"YES" forKey:@"Robby:ShowMeter"];
    [defaults registerDefaults:appDefaults];
    [defaults registerDefaults:robDefaults];
    
}

// init the app according to the preferences (user defaults)

-(void) awakeFromNib
{
[VolumeLight setBezeled:YES];
[VolumeLight setDelegate:self];

[VolumeMeter setBezeled:YES];
[VolumeMeter setDelegate:self];

iconAnimator = [[MiscAppIconAnimator alloc] init];
theImage = [NSImage alloc];

output = ! [[NSUserDefaults standardUserDefaults] boolForKey:@"Robby:Input"];

if(output)
	{
	[VolumeLight setToOutput];
	[VolumeMeter setToOutput];

	[ToggleActionMenu setTitle:@"Toggle to input level"];
	}
else	// input
	{
	[VolumeLight setToInput];
	[VolumeMeter setToInput];

	[ToggleActionMenu setTitle:@"Toggle to output level"];
	[theTapper run:self];
	}	

if([[NSUserDefaults standardUserDefaults] boolForKey:@"Robby:ShowMeter"])
	{
	boxdisplayedView = boxMeterView;
	[ToggleDisplayMenu setTitle:@"Toggle to light display"];
	[VolumeMeter run:self];
	}
else
	{
        boxdisplayedView = boxLightView;
	[ToggleDisplayMenu setTitle:@"Toggle to meter display"];
        [VolumeLight run:self];
        }
	
}

// Changes from input to output and vice-versa

- (void)ToggleAction:(id)sender
{
NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

if (output)
      	{
       	[VolumeLight setToInput];
	[VolumeMeter setToInput];

	[ToggleActionMenu setTitle:@"Toggle to output level"];
        [theTapper run:self];
        output=NO;
        [defaults setObject:@"YES" forKey:@"Robby:Input"];

        }
else
        {
        [VolumeLight setToOutput];
	[VolumeMeter setToOutput];

        [ToggleActionMenu setTitle:@"Toggle to input level"];
        [theTapper stop:self];
        output=YES;
        [defaults setObject:@"NO" forKey:@"Robby:Input"];
        }
[defaults synchronize];
return;
}

// Changes from light to meter and vice-versa

- (void)ToggleDisplay:(id)sender
{
NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

if (boxdisplayedView == boxMeterView)
	{
	[ToggleDisplayMenu setTitle:@"Toggle to meter display"];
	[VolumeLight run:self];
        [VolumeMeter stop:self];
	boxdisplayedView = boxLightView;
        [defaults setObject:@"NO" forKey:@"Robby:ShowMeter"];
	}
else
	{
        [ToggleDisplayMenu setTitle:@"Toggle to light display"];
        [VolumeLight stop:self];
        [VolumeMeter run:self];
	boxdisplayedView = boxMeterView;
        [defaults setObject:@"YES" forKey:@"Robby:ShowMeter"];
	}

[defaults synchronize];
}


// This is a function implemented by the delegate of a MiscSoundMeter 
// It is called when the meter or the light did update

// meterWillUpdateOnOwn is used instead of meterDidUpdate because the latter is called when the meter has already
// locked its focus so this may cause a re-entrency problem in the DrawRect function of the meter
// the only side effect is that the display is delayed by one frame... but it is way smoother beleive me !  

- meterWillUpdateOnOwn:sender;
{
[theImage initWithData:[boxdisplayedView  dataWithEPSInsideRect:[boxdisplayedView bounds]]];
[iconAnimator displayImage:theImage]; 
return self;

}
@end
