/*

Starter.h
Robby
 Version 2.0
 Copyright (c) 1995 by Sean Luke
 Version 3.0 & OpenStep / Rhapsody port
 Copyright (c) 1998 by Jerome Genest
 Donated to the MiscKit
MiscKit Example

 Permission to use, copy, modify, and distribute this material
 for any purpose and without fee, under the restrictions as noted
 in the MiscKit copyright notice, is hereby granted, provided that
 the MiscKit copyright notice and this permission notice
 appear in all source copies, and that the authors names shall not
 be used in advertising or publicity pertaining to this
 material without the specific, prior written permission
 of the author.  SEAN O. LUKE AMD JEROME GENEST  MAKE NO REPRESENTATIONS
 ABOUT THE ACCURACY OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.
 IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

*/

#import <AppKit/AppKit.h>

/*
Starter is the main object of Robby.  It does four things, basically:

0) Registering the default behaviour in initialize (Input, meter displayed)
1) Init according to the user defaults in awakefromnib
2) Adjust the display and save the defaults according to user actions
3) Update the application icon when the meter or light (both located in an invisible window)
   was updated.


Modifications
January 1993:  Created original version of Robby
August 14, 1995:  Ported Robby to be a MiscKit example
January 1997 Rewritten when ported to Rhapsody/Openstep
                -Now makes use of the MiscIconAnimator class instead of the Applicaton Icon Category
                -Allow the choice to display either a volume light or a volume meter

*/



@interface Starter : NSObject
{
    id ToggleActionMenu;	// menu to toggle input/output
    id ToggleDisplayMenu;	// menu to toggle meter/light
    id VolumeLight;		// volume light object located in invisible window
    id VolumeMeter;		// volume meter object located in invisible window
    id theTapper;		// Tapper to "listen" to input device
    id iconAnimator;		// copies the desired view to the appl. icon
    id boxMeterView;		// View to display, enclosing the Meter
    id boxLightView;		// View to display, enclosing the light
    id boxdisplayedView;	// either boxMeterView or boxLightView
    BOOL output;		// tracking output ?
    NSImage *theImage;		// image used to copy to the appl icon
}
- (void)ToggleAction:(id)sender;
- (void)ToggleDisplay:(id)sender;

@end
