/*
    File:       SillyBallView.h

    Contains:   View class for drawing lots of silly balls.

    Written by: Quinn "The Eskimo!"

    Created:    Thu 05-Jun-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

@interface SillyBallView : NSView
{
    // The following are connected up with Interface Builder.
    
    NSMenuItem *startStopMenuItem;		// Start/Stop menu item
    NSSlider *sliderView;			// ball rate slider
    NSTextField *textView;			// ball rate text view

    // The followintg are set up in our initWithFrame:
    
    BOOL running;				// whether we're currently drawing
    NSString *textString;			// text we're drawing
    NSSize textSize;				// size of the above, cached so we don't recalc it each time
    NSTimer *repeatTimer;			// timer that controls how often we draw a ball
    NSTimeInterval repeatPeriod;		// most recent value of the ball rate slider
}

// Standard NSView methods

- (id)initWithFrame:(NSRect)frameRect;
    // Standard init method, which sets up our instance
    // variables and starts the timer that causes the
    // ball drawing.

- (void)dealloc;
    // We override dealloc to clean up repeatTimer.

- (void)drawRect:(NSRect)rect;
    // NSView's are expected to override this method to do
    // their drawing.  We actually do nothing in this method,
    // because we don't have any persistent state.  All our drawing
    // is done in response to repeatTimer firing.  See the
    // explanation of this in ReadMe.rtf.

// Methods for drawing a single ball

- (void)drawRandomBallInside:(const NSRect *)rect;
    // Draws Silly Ball(tm) at random coordinates within
    // rect.  This method can assume we're in a state ready
    // to draw, either inside the view's drawRect routine,
    // or otherwise having the focus locked on this view.

- (void)drawAnother:(id)timer;
    // This method is called in response to repeatTimer
    // firing.  It's function is to lock focus on the view
    // and then call drawRandomBallInside.

// Internal routines for changing the ball drawing

- (void)setTimerRunning:(BOOL)run source:(id)source;
    // This routine starts or stops the timer based
    // on the value of run.  source is the user interface
    // element that caused the action; it is used to
    // prevent double setting of user interface elements
    // whose values have already changed.  Pass nil
    // if you don't have anything obvious to pass here.

- (void)setTimerPeriod:(float)repPeriod source:(id)source;
    // This routine changes the period of the timer based
    // on the value of repPeriod.  repPeriod is assumed
    // to be the value of the ball rate slider, ie 0 to
    // 5, and is scaled appropriately to a real timer
    // frequency.  source is the user interface
    // element that caused the action; it is used to
    // prevent double setting of user interface elements
    // whose values have already changed.  Pass nil
    // if you don't have anything obvious to pass here.

// Interface Builder actions

- (void)forceRedraw:(id)source;
    // The purpose of this action is to clear out all the
    // silly balls in the view so you can see the balls
    // draw.  The action is wired to the "Clear" menu
    // command.

- (void)startOrStop:(id)source;
    // The purpose of this action is to either start or
    // stop the drawing of balls.  Internally, it calls
    // straight through to setTimerRunning:source:.
    // The action is wired to the "Start"/"Stop" menu
    // command.

- (void)setPeriod:(id)source;
    // THe purpose of this action is to set the period
    // at which the balls draw.  Internally it calls
    // setTimerPeriod:source:.  It's wired to the
    // Ball Rate slider.

@end
