/*
    File:       AnimalView.h

    Contains:   Header file for the AnimalView class.

    Written By:	Julie Zelenski

    Created:    June 19, 1997

    Copyright:  (c) 1997 by Apple Computer, Inc., all rights reserved.

    Change History: Originally written by Julie Zelenski.
		     Redesigned for Rhapsody by Stephen Chick.

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

//  Class interface.

@interface AnimalView : NSView
{
	NSImageRep *imageRep;	//  The animal image.
	BOOL shrunk;		//  YES if the image is shrunk.
}

//  Initialization and deallocation methods.

- (id) initWithFrame:(NSRect) frameRect;
- (void) dealloc;

//  Target action methods.

- (void) changeAnimal:(id) sender;
- (void) shrinkEnlarge:(id) sender;
- (void) rotateLeft:(id) sender;
- (void) rotateRight:(id) sender;

//  Private methods.

- (void) setImageToAnimal:(NSString *) imageName;
- (void) drawRect:(NSRect) aRect;

@end
