/* cpdfColor.c  -- color functions
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

1998-07-09 [IO]
*/

#include "version.h"

#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"		/* This must be included before all other local include files */
#include "cglobals.h"

void cpdf_setgray(float gray)		/* set both fill and stroke grays */
{
	cpdf_setgrayFill(gray);
	cpdf_setgrayStroke(gray);
}

void cpdf_setrgbcolor(float r, float g, float b)	/* set both fill and stroke colors */
{
	cpdf_setrgbcolorFill(r, g, b);
	cpdf_setrgbcolorStroke(r, g, b);
}

void cpdf_setgrayFill(float gray)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f g\n", gray);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f g\n", gray);
}

void cpdf_setgrayStroke(float gray)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f G\n", gray);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f G\n", gray);
}

void cpdf_setrgbcolorFill(float r, float g, float b)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f %.4f %.4f rg\n", r, g, b);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f %.4f %.4f rg\n", r, g, b);
}

void cpdf_setrgbcolorStroke(float r, float g, float b)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f %.4f %.4f RG\n", r, g, b);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f %.4f %.4f RG\n", r, g, b);
}

void cpdf_setcmykcolorFill(float c, float m, float y, float k)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f %.4f %.4f %.4f k\n", c, m, y, k);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f %.4f %.4f %.4f k\n", c, m, y, k);
}

void cpdf_setcmykcolorStroke(float c, float m, float y, float k)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f %.4f %.4f %.4f K\n", c, m, y, k);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f %.4f %.4f %.4f K\n", c, m, y, k);
}

