/* Minimal.c -- A simple drawing and one-line text example.
		It can't be really simpler than this without being silly.

 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

cc -Wall -o Minimal -I/usr/local/include Minimal.c -lcpdf

1998-07-18  [IO]
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "cpdflib.h"

void main(int argc, char *argv[])
{
int i;
float x, y, angle;
float radius2= 1.2;
float xorig = 2.5, yorig = 2.5;

    if(argc != 2) {
	fprintf(stderr, "Usage: %s file.pdf\n    User '-' as argument for stdout output.\n", argv[0]);
	exit(0);
    }

    /* == Initialization == */
    cpdf_open(0);
    cpdf_enableCompression(YES);		/* use Flate/Zlib compression */
    cpdf_init();
    cpdf_pageInit(1, PORTRAIT, LETTER, LETTER);		/* page orientation */
    cpdf_translate(0.0, 6.0);

    /* == Simple graphics drawing example == */
    for(i=0; i<=200; i++) {
	angle = PI*(float)i/100.0;		/* 0 .. 2pi */
	x = radius2 * cos(3.0*angle) + xorig;
	y = radius2 * sin(5.0*angle) + yorig;
	if(i) cpdf_lineto(x, y);
	else  cpdf_moveto(x, y);		/* first point */
    }
    cpdf_closepath();
    cpdf_setrgbcolorFill(1.0, 0.7, 0.7);	/* pink as fill color */
    cpdf_setrgbcolorStroke(0.0, 0.0, 1.0);	/* blue as stroke color */
    cpdf_eofillAndStroke();			/* even-odd fill and stroke*/

    /* == Text example == */
    cpdf_setgrayFill(0.0);				/* Black */
    cpdf_beginText(0);
    cpdf_setFont("Times-Italic", "MacRomanEncoding", 16.0);
    cpdf_text(1.6, 1.0, 0.0, "x=cos(3t), y=sin(5t)");	/* cpdf_text() may be repeatedly used */
    cpdf_endText();

    cpdf_finalizeAll();			/* PDF file/memstream is actually written here */
    cpdf_savePDFmemoryStreamToFile(argv[1]);

    /* == Clean up == */
    cpdf_close();			/* shut down */
    if(strcmp(argv[1], "-") != 0)
        cpdf_launchPreview();		/* launch Acrobat/PDF viewer on the output file */
}

