/* MarkerTest.c -- Draws all marker symbols, filled and open.
		   Also draws pointer arrows.
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

cc -Wall -o MarkerTest -I/usr/local/include MarkerTest.c -lcpdf

1998-08-16  [IO]
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "cpdflib.h"

#define NUMMARKERS	11
#define XBUMP		0.35

void main(int argc, char *argv[])
{
float x, y1, y2, y0, x0 = 1.0;
char strbuf[128];
int i;
float markersize = 12.0;
	cpdf_open(0);
	cpdf_enableCompression(1);
	cpdf_setCreator("cc*PDF Demo Program: MarkerTest.c");
	cpdf_init();
	cpdf_pageInit(1, PORTRAIT, LETTER, LETTER);		/* page orientation */
        cpdf_translate(0.0, 6.5);

	/* Your drawing code in PDF below */
	/* ----------------------------------------------------------------------------------------- */

	/* draw dashed lines to define reference points at which markers are positioned. */
	cpdf_setdash("[2 2] 0");
	cpdf_setlinewidth(0.12);
	y1 = 1.3;
	cpdf_moveto(1.1, y1);
	cpdf_lineto(6.9, y1);
	y2 = 1.6;
	cpdf_moveto(1.1, y2);
	cpdf_lineto(6.9, y2);

	y0 = 1.45;
	for(i=0; i< (NUMMARKERS + 4); i++) {
	    if(i < NUMMARKERS)
	        x = XBUMP * (float)i + XBUMP + x0;
	    else
	        x = XBUMP * (float)i + XBUMP*2.0 + x0;
	    cpdf_moveto(x, y0+0.45);
	    cpdf_lineto(x, y0-0.45);
	}
	cpdf_stroke();
	cpdf_nodash();

	/* Draw markers and pointers at intersections defined by dashed lines */
	/* First do filled (black) symbols */
	cpdf_setgrayStroke(0.0);
	cpdf_setgrayFill(0.0);
	for(i=0; i< (NUMMARKERS + 4); i++) {
	    if(i < NUMMARKERS) {
	        x = XBUMP * (float)i + XBUMP + x0;
	        cpdf_marker(x, y1, i, markersize);	/* filled */
	    }
	    else {
	        x = XBUMP * (float)i + XBUMP*2 + x0;
	        cpdf_pointer(x, y1, i-NUMMARKERS, markersize);	/* filled */
	    }
	}

	/* Do open symbols */
	cpdf_setgrayStroke(0.0);
	cpdf_setgrayFill(1.0);
	for(i=0; i< (NUMMARKERS + 4); i++) {
	    if(i < NUMMARKERS) {
	        x = XBUMP * (float)i + XBUMP + x0;
	        cpdf_marker(x, y2, i, markersize);	/* open */
	    }
	    else {
	        x = XBUMP * (float)i + XBUMP*2 + x0;
	        cpdf_pointer(x, y2, i-NUMMARKERS, markersize);	/* open */
	    }
	}

	/* Show symbol number above corresponding symbols */
	cpdf_setgrayFill(0.0);		/* black */
	cpdf_beginText(0);
	cpdf_setFont("Helvetica", "MacRomanEncoding", 12.0);
	for(i=0; i< (NUMMARKERS + 4); i++) {
	    if(i < NUMMARKERS) {
	        x = XBUMP * (float)i + XBUMP + x0;
		if(i == 10) x -= 0.06;
	        sprintf(strbuf, "%d", i);
	    }
	    else {
	        x = XBUMP * (float)i + XBUMP*2 + x0;
	        sprintf(strbuf, "%d", i-NUMMARKERS);
	    }
	    cpdf_text(x-0.05, y0+0.52, 0.0, strbuf);
	}
	cpdf_endText();

	cpdf_beginText(0);
	cpdf_setFont("Times-Roman", "MacRomanEncoding", 14.0);
	cpdf_text(1.2, 2.6, 0.0, "MarkerTest.c  --   markersize = 12 points");
	cpdf_text(2.55, 2.24, 0.0, "cpdf_marker()");
	cpdf_text(5.48, 2.24, 0.0, "cpdf_pointer()");
	cpdf_endText();

	/* ----------------------------------------------------------------------------------------- */
	/* Your drawing code in PDF above */
        cpdf_finalizeAll();			/* PDF file/memstream is actually written here */
	cpdf_savePDFmemoryStreamToFile("markers.pdf");

	cpdf_close();			/* shut down */
	cpdf_launchPreview();		/* launch Acrobat/PDF viewer on the output file */
}

