// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFScheduledEvent.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "OFInvocation.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/Scheduling.subproj/OFScheduledEvent.m,v 1.4 1998/12/08 04:08:33 kc Exp $")

@implementation OFScheduledEvent

static Class myClass;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    myClass = self;
}

- initWithInvocation:(OFInvocation *)anInvocation atDate:(NSDate *)aDate;
{
    invocation = [anInvocation retain];
    date = [aDate retain];
    return self;
}

- initForObject:(id)anObject selector:(SEL)aSelector withObject:(id)aWithObject atDate:(NSDate *)aDate;
{
    OFInvocation *anInvocation;
    OFScheduledEvent *newEvent;

    anInvocation = [[OFInvocation alloc] initForObject:anObject selector:aSelector withObject:aWithObject];
    newEvent = [self initWithInvocation:anInvocation atDate:aDate];
    [anInvocation release];
    return newEvent;
}

- (void)dealloc;
{
    [invocation release];
    [date release];
    [super dealloc];
}

- (OFInvocation *)invocation;
{
    return [[invocation retain] autorelease];
}

- (NSDate *)date;
{
    return [[date retain] autorelease];
}

- (void)invoke;
{
    [invocation invoke];
}

- (NSComparisonResult)compare:(OFScheduledEvent *)otherEvent;
{
    if (![otherEvent isKindOfClass:[self class]])
	return NSOrderedAscending;

    switch ([date compare:otherEvent->date]) {
    case NSOrderedAscending:
	return NSOrderedAscending;
    case NSOrderedDescending:
	return NSOrderedDescending;
    default:
    case NSOrderedSame:
	if (invocation == otherEvent->invocation)
	    return NSOrderedSame;
	else if (invocation < otherEvent->invocation)
	    return NSOrderedAscending;
	else
	    return NSOrderedDescending;
    }
}

- (unsigned int)hash;
{
    return [invocation hash];
}

- (BOOL)isEqual:(id)anObject;
{
    OFScheduledEvent *otherEvent;

    otherEvent = anObject;
    if (otherEvent == self)
	return YES;
    if (otherEvent->isa != myClass)
	return NO;
    return [invocation isEqual:otherEvent->invocation] &&
	   [date isEqual:otherEvent->date];
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    [debugDictionary setObject:invocation forKey:@"invocation"];
    [debugDictionary setObject:date forKey:@"date"];

    return debugDictionary;
}

- (NSString *)shortDescription;
{
    return [NSString stringWithFormat:@"%@: %@", [date description], [invocation shortDescription]];
}

@end
