// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSNotificationCenter-OFExtensions.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OpenStepExtensions.subproj/NSNotificationCenter-OFExtensions.m,v 1.2 1998/12/08 04:08:20 kc Exp $")

@implementation NSNotificationCenter (OFExtensions)

- (void)addObserver:(id)observer
           selector:(SEL)aSelector
               name:(NSString *)aName
            objects:(NSArray *)objects
{
    unsigned int objectIndex;

    objectIndex = [objects count];
    while (objectIndex--)
        [self addObserver: observer
                 selector: aSelector
                     name: aName
                  objects: [objects objectAtIndex: objectIndex]];
}

- (void)removeObserver:(id)observer
                  name:(NSString *)aName
               objects:(NSArray *)objects;
{
    unsigned int objectIndex;

    objectIndex = [objects count];
    while (objectIndex--)
        [self removeObserver: observer
                        name: aName
                     objects: [objects objectAtIndex: objectIndex]];
}

@end
