// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OFZone.h,v 1.2 1998/12/08 04:07:56 kc Exp $

#import "OFObject.h"

/* This is a simple OO wrapper around an NSZone pointer to allow refcounting (in particular, autoreleasing). When the OFZone is dealloced, it calls NSRecycleZone(). */

@interface OFZone : OFObject
{
    BOOL ownsZone;
@public
    NSZone *zone;
}

+ zoneForNSZone:(NSZone *)aZone;
+ defaultZone;
+ new;

/* Designated initializer; private API */
- _initWithNSZone:(NSZone *)aZone;

- (void)recycle;

- (NSZone *)nsZone;  /* NB: -[OFZone zone] returns the zone the OFZone is allocated *in*, not the zone it *represents* ! */

- (void)setName:(NSString *)newName;
- (NSString *)name;

@end
