// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OFBundleRegistry.h,v 1.6 1998/12/08 04:07:42 kc Exp $

// OFBundleRegistry searches for loadable bundles, then processes the OFRegistrations for all software components (i.e. frameworks, the application, and any loadable bundles).

#import "OFObject.h"

@class NSBundle;

@interface OFBundleRegistry : OFObject
{
}

+ (NSDictionary *)softwareVersionDictionary;
    // Returns a dictionary of the registered software versions.

@end

// OFBundleRegistryTarget informal protocol
@interface NSObject (OFBundleRegistryTarget)
+ (void)registerItemName:(NSString *)itemName bundle:(NSBundle *)bundle description:(NSDictionary *)description;
@end
