// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFByteSet.h,v 1.3 1998/12/08 04:07:59 kc Exp $

#import "OFObject.h"

@class NSData;

#import <Foundation/NSString.h> // For unichar and NSStringEncoding

#define OFByteSetBitmapRepLength (0xff >> 3)

@interface OFByteSet : OFObject
{
@public
    byte bitmapRep[OFByteSetBitmapRepLength];
}

- (BOOL)byteIsMember:(byte)aByte;
- (void)addByte:(byte)aByte;
- (void)removeByte:(byte)aByte;

- (void)addAllBytes;
- (void)removeAllBytes;

- (void)addBytesFromData:(NSData *)data;
- (void)addBytesFromString:(NSString *)string encoding:(NSStringEncoding)encoding;
- (void)removeBytesFromData:(NSData *)data;
- (void)removeBytesFromString:(NSString *)string encoding:(NSStringEncoding)encoding;

- (NSData *)data;
- (NSString *)stringUsingEncoding:(NSStringEncoding)encoding;

@end

@interface OFByteSet (PredefinedSets)
+ (OFByteSet *)whitespaceByteSet;
@end

static inline BOOL isByteInByteSet(byte aByte, OFByteSet *byteSet)
{
    return byteSet->bitmapRep[aByte >> 3] & (((unsigned)1) << (aByte & 7));
}

static inline BOOL isCharacterInByteSet(unichar ch, OFByteSet *byteSet)
{
    if (ch & 0xff00)
        return NO;
    return isByteInByteSet(ch, byteSet);
}

static inline void addByteToByteSet(byte aByte, OFByteSet *byteSet)
{
    byteSet->bitmapRep[aByte >> 3] |= (((unsigned)1) << (aByte & 7));
}

static inline void
removeByteFromByteSet(byte aByte, OFByteSet *byteSet)
{
    byteSet->bitmapRep[aByte >> 3] &= ~(((unsigned)1) << (aByte & 7));
}

