/*
    File:       QResourceObject.m

    Contains:   An object to encapsulate a Mac OS resource derived from a QResourceFile.

    Written by: Quinn "The Eskimo!"

    Created:    Mon 19-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

/* QResourceObject.m created by eskimo1 on Mon 19-May-1997 */

#import "QResourceObject.h"

@implementation QResourceObject

- (id)initWithResourceType:(QResourceType)aResType
    // See comments in interface part.
{
    return [self initWithResourceType:aResType resourceID:0 resourceName:nil resourceData:nil resourceAttributes:0];
}

- (id)initWithResourceType:(QResourceType)aResType resourceID:(long)aResID resourceName:(NSString *)aResName
                   resourceData:(NSData *)aResData resourceAttributes:(long)aResAttributes
    // See comments in interface part.
{
    self = [super init];
    
    if (self != nil) {
        resType = aResType;
        resID = aResID;
        resName = [aResName retain];
        resData = [aResData retain];
        resAttributes = aResAttributes;
    }
    
    return (self);
}

- (id)init
    // Call through to the designated initialiser.
{
    return ( [self initWithResourceType:0 resourceID:0 resourceName:0 resourceData:nil resourceAttributes:0] );
}

- (QResourceType)resourceType
    // See comments in interface part.
{
    return (resType);
}

- (long)resourceID
    // See comments in interface part.
{
    return (resID);
}

- (NSString *)resourceName
    // See comments in interface part.
{
    return (resName);
}

- (NSData *)resourceData
    // See comments in interface part.
{
    return (resData);
}

- (long)resourceAttributes
    // See comments in interface part.
{
    return (resAttributes);
}

- (NSString *)description
    // See comments in interface part.
{
    char osTypeString[5];
    NSString *retString;

    // Convert a four character code into a string in a long winded, but
    // byte order friendly, way.
    
    osTypeString[0] = resType >> 24;
    osTypeString[1] = resType >> 16;
    osTypeString[2] = resType >> 8;
    osTypeString[3] = resType >> 0;
    osTypeString[4] = 0;

    // Create the resulting string 'xxxx' [ ID=y ] [ "zzzzzz" ], with the bits
    // in square brackets being optional.
    
    retString = [NSString stringWithFormat:@"'%s'", osTypeString ];
    if (resData != nil) {
        retString = [retString stringByAppendingFormat:@" ID=%d", resID ];
    }
    if (resName != nil) {
        retString = [retString stringByAppendingFormat:@" \"%@\"", resName ];
    }
    return retString;
}

- (void)dealloc
    // See comments in interface part.
{
    [resName release];
    [resData release];
    [super dealloc];
}

@end
