/*
    File:       QResourceEnumerator.m

    Contains:   An enumerator that returns all the resources of a given type
                in a resource file.

    Written by: Quinn "The Eskimo!"

    Created:    Mon 19-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "QResourceEnumerator.h"

#import "QResourceFile.h"

@implementation QResourceEnumerator

- (id)initWithResourceFile:(QResourceFile*)aResFile andType:(QResourceType)aResType
    // See comments in interface part.
{
    self = [super init];
    
    if (self != nil) {

        NSAssert( aResFile != nil, @"Cannot create a QResourceEnumerator without a resource file");
        
        // Latch the parameters.
        
        resFile = aResFile;
        resType = aResType;

        // Set up the index to the next resource we're going to return.
        
        resourceIndex = 0;

        // Check that there are any resources of the specified type, and get the number
        // of resources and the offset to the reference list.
        
        if ( ! [resFile findForType:aResType numResources:&numResourcesOfThisType refList:&referenceListOffset] ) {

            // Hmmm, there aren't any resources of type aResType.  Let's just set ourselves
            // up so that nextObject always returns nil.
            
            numResourcesOfThisType = 0;
            referenceListOffset = -1;
        }
    }
    
    return (self);
}

- (id)init
    // Call through to the designated initialiser.
    // In the non-subclassed case, we violate the pre-condition of the
    // designated initialiser by passing in a nil path pointer.
    // We do this because a) it's the right thing to do (see the book
    // "Object-Oriented Programming and the Objective-C Language" for
    // the reasoning), and b) a subclasser may want to subclass us in a
    // weird way.
{
    return ( [self initWithResourceFile:nil andType:0] );
}

- (QResourceObject *)nextObject
    // See comments in interface part.
{
    QResourceObject *result = nil;

    if ( resourceIndex < numResourcesOfThisType ) {

        result = [resFile resourceGivenType:resType andReferenceOffset:referenceListOffset + 12 * resourceIndex];
        
        resourceIndex += 1;
    }

    return (result);
}

@end
