/*
    File:       QMacDataAccess.m

    Contains:   Additions to NSData for accessing common Mac OS data types

    Written by: Quinn "The Eskimo!"

    Created:    Tue 20-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "QMacDataAccess.h"

#import "QPStringAdditions.h"

@implementation NSData (QMacDataAccess)

// Implementation Note:
//
// These routines assume that the machine can access words that are not aligned
// on word boundaries.  This is true on my target architectures (PowerPC and i386)
// but is not true on all machines (eg original 68000 and other RISC processors).
// This file would require a different implementation on such a machine.

- (UInt32)MacUInt32AtOffset:(UInt32)offset
    // See comments in interface part.
{
    UInt32 tmp;

    NSAssert( offset <= [self length] - 4, @"MacUInt32AtOffset range check failed" );
    
    tmp = *((UInt32 *) ( ((char *) [self bytes]) + offset));
    tmp = NSSwapBigLongToHost(tmp);
    return (tmp);
}

- (UInt16)MacUInt16AtOffset:(UInt32)offset
    // See comments in interface part.
{
    UInt16 tmp;
    
    NSAssert( offset <= [self length] - 2, @"MacUInt16AtOffset range check failed" );

    tmp = *((UInt16 *) ( ((char *) [self bytes]) + offset));
    tmp = NSSwapBigShortToHost(tmp);
    return (tmp);
}

- (UInt8) MacUInt8AtOffset: (UInt32)offset
    // See comments in interface part.
{
    UInt8 tmp;
    
    NSAssert( offset <= [self length] - 1, @"MacUInt8AtOffset range check failed" );

    tmp = *((UInt8 *) ( ((char *) [self bytes]) + offset));
    return (tmp);
}

- (SInt32)MacSInt32AtOffset:(UInt32)offset
    // See comments in interface part.
{
    return (SInt32) [self MacUInt32AtOffset:offset];
}

- (SInt16)MacSInt16AtOffset:(UInt32)offset
    // See comments in interface part.
{
    return (SInt16) [self MacUInt16AtOffset:offset];
}

- (SInt8) MacSInt8AtOffset: (UInt32)offset
    // See comments in interface part.
{
    return (SInt8) [self MacUInt8AtOffset:offset];
}

- (NSString *)MacPStringAtOffset:(UInt32)offset
    // See comments in interface part.
{
    UInt8 * pString;
    
    NSAssert( offset <= [self length] - 1, @"MacPStringAtOffset range check failed 1" );
    
    pString = ( (UInt8*) [self bytes] ) + offset;
    
    NSAssert( offset <= [self length] - *pString - 1, @"MacPStringAtOffset range check failed 2" );
    
    return [NSString stringWithPString:(StringPtr) pString];
}

- (NSRect)MacRectAtOffset:(UInt32)offset
    // See comments in interface part.
{
    long top;
    long left;
    long bottom;
    long right;
    
    top    = [self MacSInt16AtOffset:offset + 0];
    left   = [self MacSInt16AtOffset:offset + 2];
    bottom = [self MacSInt16AtOffset:offset + 4];
    right  = [self MacSInt16AtOffset:offset + 6];

    return NSMakeRect(left, top, right - left, bottom - top);
}

@end
