/*
    File:       ClockView.h

    Contains:   Header file for the ClockView class.

    Written By:	Ali T. Ozer

    Created:	June 19, 1997

    Copyright:	(c) 1997 by Apple Computer, Inc., all rights reserved.

    Change History:	Redesigned for 2.0 by Julie Zelenski.
			Modified for 3.0 by Ali Ozer.
			Redesigned for Rhapsody by Stephen Chick.
			Changed to use NSCalendarDate to draw times (10/14/97, SC).

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

//  Class interface.

@interface ClockView : NSView
{
	int clockType;		//  Clock type (analog, digital, or sundial).
	BOOL showSeconds;	//  Show the seconds hand.
	BOOL showDate;	 	//  Show the date.

	NSFont *littleFont;	//  Font setting for the analog date.
	NSFont *mediumFont;	//  Font setting for the digital date.
	NSFont *bigFont;	//  Font setting for the digital time.

	float radius; 	 	//  Radius of the clock face.
	NSPoint center;		//  Center of the clock face.
	NSImage *face;		//  NSImage of the clock face.

	BOOL timerRepeats;	//  YES: The timer is a repeating timer.
	NSTimer *timer;		//  Currently active NSTimer.
}

//  Initialization and deallocation methods.

- (id) initWithFrame:(NSRect) frameRect;
- (void) dealloc;

//  Parameter get/set methods.

- (int) clockType;
- (BOOL) showSeconds;
- (BOOL) showDate;
- (void) setClockType:(int) newValue;
- (void) setShowSeconds:(BOOL) newValue;
- (void) setShowDate:(BOOL) newValue;

//  Target action methods.

- (void) changeShowDate:(id) sender;		/* connect to toggle (2-state) control */
- (void) changeShowSeconds:(id) sender;		/* connect to toggle (2-state) control */
- (void) changeClockType:(id) sender;		/* connect to int value (3 value) control */

//  Private methods.

- (void) drawAnalog:(NSCalendarDate *)date;
- (void) drawDigital:(NSCalendarDate *)date;
- (void) drawSundial:(NSCalendarDate *)date;
- (void) drawFace;
- (void) drawRect:(NSRect) rect;
- (void) startTimer:(BOOL)fireASAP;
- (void) showTime:(NSTimer *) sender;

//  Notification methods.

- (void) viewBoundsDidChange:(NSNotification *) aNotification;

@end
