/*
    File:       BusyBoxApp.m

    Contains:	Generic application controller class.

    Written By:	Stephen Chick

    Created:    June 19, 1997

    Copyright:  (c) 1997 by Apple Computer, Inc., all rights reserved.

    Change History: Added delegate method (7/15/97, SC).

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "BusyBoxApp.h"

@implementation BusyBoxApp

//-----------------------------------------------------------------------------
//
//  init
//
//  Register to receive notification when the application has finished
//  launching.
//

- (id) init
{
	self = [super init];

	//  Register with the default notification center to receive a
	//  notification when we finish launching. We pass a selector for our
	//  applicationDidFinishLaunching: method which will be called when
	//  the notification is invoked.

	[[NSNotificationCenter defaultCenter] addObserver:self
	  selector:@selector (applicationDidFinishLaunching:)
	  name:@"NSApplicationDidFinishLaunchingNotification" object:nil];
	return self;
}

//-----------------------------------------------------------------------------
//
//  dealloc
//
//  Deregister our notification requests.
// 

- (void) dealloc
{
	//  Remove ourselves as a notification target.

	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}

//-----------------------------------------------------------------------------
//
//  about:
//
//  Target action for an Interface Builder control. Opens the about panel.
//

- (void) about:(id) sender
{
	//  Load the nib file that contains the info panel.

	if (aboutPanel == nil) {
		if (![NSBundle loadNibNamed:@"InfoPanel.nib" owner:self])
			NSLog (@"Could not load InfoPanel.nib");

		//  If we're opening the info panel for the first time,
		//  center it on the screen.

		[aboutPanel center];
	}

	//  Bring the info panel to the front.

	[aboutPanel makeKeyAndOrderFront:self];
}

//-----------------------------------------------------------------------------
//
//  preferences:
//
//  Target action for an Interface Builder control. Opens the preferences panel.
//

- (void) preferences:(id) sender
{
	//  Load the nib file that contains the preferences panel.

	if (preferencesPanel == nil) {
		if (![NSBundle loadNibNamed:@"PrefPanel.nib" owner:self])
			NSLog (@"Could not load PrefPanel.nib");

		//  If we're opening the preferences panel for the first time,
		//  center it on the screen.

		[preferencesPanel center];
	}

	//  Bring the preferences panel to the front.

	[preferencesPanel makeKeyAndOrderFront:self];
}

//-----------------------------------------------------------------------------
//
//  applicationDidFinishLaunching:
//
//  applicationDidFinishLaunching: is invoked when the application finishes
//  launching. We bring the main window to the front and center it on the
//  screen.
//

- (void) applicationDidFinishLaunching:(NSNotification *) aNotification
{
	[mainWindow center];
	[mainWindow makeKeyAndOrderFront:self];
}

//-----------------------------------------------------------------------------
//
//  applicationShouldTerminateAfterLastWindowClosed:
//
//  applicationShouldTerminateAfterLastWindowClosed: is a delegate method used
//  to indicate that the application should automatically quit when the user
//  closes all windows.
//

- (BOOL) applicationShouldTerminateAfterLastWindowClosed:(NSApplication *) application
{
        return YES;
}

@end
