/*
    File:       BusyBoxApp.h

    Contains:   Header file for the BusyBoxApp class.

    Written By:	Stephen Chick

    Created:    June 19, 1997

    Copyright:  (c) 1997 by Apple Computer, Inc., all rights reserved.

    Change History: Added delegate method (7/15/97, SC).

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

//  Class interface.

@interface BusyBoxApp : NSObject
{
	id mainWindow;		//  Main window (connected in IB).
	id aboutPanel;		//  About panel (connected in IB).
	id preferencesPanel;	//  Preferences panel (connected in IB).
}

//  Initialization and deallocation methods.

- (id) init;
- (void) dealloc;

//  Target action methods.

- (void) about:(id) sender;
- (void) preferences:(id) sender;

//  Notification methods.

- (void) applicationDidFinishLaunching:(NSNotification *) aNotification;

//  Delegate methods.

- (BOOL) applicationShouldTerminateAfterLastWindowClosed:(NSApplication *) application;

@end
