/* PrefsController.m created by sanguish on Thu 24-Dec-1998 */

#import "PrefsController.h"

@implementation PrefsController

+ (id)sharedInstance
{
    static PrefsController *_sharedPreferencesController = nil;


    if (!_sharedPreferencesController) {
        _sharedPreferencesController = [[PrefsController allocWithZone:[self zone]] init];
    }
    return _sharedPreferencesController;
}

- (void)showWindow
{
    [self syncPreferencesPanelToCurrentSettings];
    [preferencesWindow center];
    [preferencesWindow makeKeyAndOrderFront:self];
}
- (void)hideWindow
{
    [preferencesWindow orderOut:self];
}

- (void)defaultsMayNeedRefreshing:(NSNotification *)notification
{
    [self syncPreferencesPanelToCurrentSettings];
}

- init
{
    if ([super init])
      {
        [NSBundle loadNibNamed:@"Preferences" owner:self];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(defaultsMayNeedRefreshing:)
                                                     name:NSWindowDidBecomeKeyNotification
                                                   object:preferencesWindow];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(defaultsMayNeedRefreshing:)
                                                     name:NSWindowDidBecomeMainNotification
                                                   object:preferencesWindow];
       
        
      }
    return self;
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}


- (void)awakeFromNib
{
    NSTabViewItem *tempTabItem;
    
    // Create Temp Directories view
    tempTabItem=[[[NSTabViewItem alloc] initWithIdentifier:@"DecompressionLocation"] autorelease];
    [tempTabItem setLabel:@"File Location"];
    [tempTabItem setView:decompressionTargetBox];
    [preferencesTabView addTabViewItem:tempTabItem];

    tempTabItem=[[[NSTabViewItem alloc] initWithIdentifier:@"Notifications"] autorelease];
    [tempTabItem setLabel:@"Notification"];
    [tempTabItem setView:notificationsBox];
    [preferencesTabView addTabViewItem:tempTabItem];

    tempTabItem=[[[NSTabViewItem alloc] initWithIdentifier:@"Expert"] autorelease];
    [tempTabItem setLabel:@"Expert"];
    [tempTabItem setView:expertBox];
    [preferencesTabView addTabViewItem:tempTabItem];


}


- (void)showPreferencesPanel:sender
{
    [self syncPreferencesPanelToCurrentSettings];
    [preferencesWindow center];
    [preferencesWindow makeKeyAndOrderFront:self];

}
- (void)setTemporaryFilesDirectory:sender
{
    NSString *thePath;

    thePath=[self showPanelForDirectoryWithInitialPath:[[NSUserDefaults standardUserDefaults] stringForKey:@"DecompressedFilesDirectory"]];

    if (thePath)
      {
        [temporaryFilesDirectoryField setStringValue:thePath];
        [[NSUserDefaults standardUserDefaults] setObject:thePath
                                                  forKey:@"DecompressedFilesDirectory"];
        [[NSUserDefaults standardUserDefaults] synchronize];
      }

}

- (NSString *)showPanelForDirectoryWithInitialPath:(NSString *)thePath
{
    int result;
    NSOpenPanel *sharedOpenPanel = [NSOpenPanel openPanel];
    NSString *startPath;

    if (!thePath)
        startPath=NSHomeDirectory();
    else
        startPath=thePath;
    [sharedOpenPanel setCanChooseDirectories:YES];
    [sharedOpenPanel setCanChooseFiles:NO];
    [sharedOpenPanel setAllowsMultipleSelection:NO];

    result = [sharedOpenPanel runModalForDirectory:startPath file:nil types:nil];
    if (result == NSOKButton)
      {
        return [[[sharedOpenPanel filenames] lastObject] stringByAbbreviatingWithTildeInPath];
      }
    return nil;
}

- (void)takeValueFromTemporaryFilesDirectoryField:sender
{
    [[NSUserDefaults standardUserDefaults] setObject:[temporaryFilesDirectoryField stringValue]
                                              forKey:@"DecompressedFilesDirectory"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

// - selectedCheckTempFilesOnQuit:sender;
//
// Each time you click on the Checkbox in the Preferences Panel,
// this method is called.  It determines the state of the Checkbox
// and then sets the default as appropriate

- selectedCheckTempFilesOnQuit:sender;
{
    // This is called every time you click on the check box, its
    // connection is made in Interface Builder the defaults are
    // saved periodically to disk, but we'll force it in this case.
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"DefaultDeleteValueIsYes"];
    [[NSUserDefaults standardUserDefaults] synchronize];
    return self;
}

// - selectedDeleteTempFilesOnQuit:sender;
//
// Each time you click on the Checkbox in the Preferences Panel,
// this method is called.  It determines the state of the Checkbox
// and then sets the default as appropriate

- selectedDeleteTempFilesOnQuit:sender;
{
    // This is called every time you click on the check box, its
    // connection is made in Interface Builder the defaults are
    // saved periodically to disk, but we'll force it in this case.
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"DeleteTempFilesOnQuit"];
    [[NSUserDefaults standardUserDefaults] synchronize];
    return self;
}

- (void)syncPreferencesPanelToCurrentSettings;
{
    NSUserDefaults *userDefaults;

    userDefaults=[NSUserDefaults standardUserDefaults];
    [userDefaults synchronize];
    [preferencesDeleteFilesCheckbox setIntValue:[userDefaults boolForKey:@"DeleteTempFilesOnQuit"]];
    [temporaryFilesDirectoryField setStringValue:[userDefaults stringForKey:@"DecompressedFilesDirectory"]];

    [defaultDeleteCheckValueCheckbox setIntValue:[userDefaults boolForKey:@"DefaultDeleteValueIsYes"]];
   
    {
        BOOL playCompressionSound;
        NSString *compressionSoundPath;
        BOOL showPanelWhenCompressionFinishes;
        BOOL selectInWorkspaceAfterCompress;
        
        playCompressionSound=[userDefaults boolForKey:@"PlayCompressionSound"];
        showPanelWhenCompressionFinishes=[userDefaults boolForKey:@"ShowPanelWhenCompressionFinishes"];

        [playCompressionSoundCheckbox setIntValue:playCompressionSound];
        compressionSoundPath=[userDefaults stringForKey:@"CompressionSound"];
        [compressionSoundField setStringValue:compressionSoundPath ? compressionSoundPath : @""];
        [showCompressionPanelCheckbox setIntValue:showPanelWhenCompressionFinishes];

        [compressionSoundField setEnabled:playCompressionSound];
        [setCompressionSoundPathButton setEnabled:playCompressionSound];

        selectInWorkspaceAfterCompress =
            [userDefaults boolForKey:@"SelectInWorkspaceAfterCompress"];
        [selectInWorkspaceAfterCompressionCheckbox setIntValue:selectInWorkspaceAfterCompress];
    }

    {
        BOOL playDecompressionSound;
        NSString *decompressionSoundPath;
        BOOL showPanelWhenDecompressionFinishes;
        BOOL selectInWorkspaceAfterDecompress;
        
        playDecompressionSound=[userDefaults boolForKey:@"PlayDecompressionSound"];
        showPanelWhenDecompressionFinishes=[userDefaults boolForKey:@"ShowPanelWhenDecompressionFinishes"];

        [playDecompressionSoundCheckbox setIntValue:playDecompressionSound];
        decompressionSoundPath=[userDefaults stringForKey:@"DecompressionSound"];
        [decompressionSoundField setStringValue:decompressionSoundPath ? decompressionSoundPath : @""];
        [showDecompressionPanelCheckbox setIntValue:showPanelWhenDecompressionFinishes];

        [decompressionSoundField setEnabled:playDecompressionSound];
        [setDecompressionSoundPathButton setEnabled:playDecompressionSound];

        selectInWorkspaceAfterDecompress =
            [userDefaults boolForKey:@"SelectInWorkspaceAfterDecompress"];
        [selectInWorkspaceAfterDecompressionCheckbox setIntValue:selectInWorkspaceAfterDecompress];

    }

}



- (NSString *)showPanelForSoundWithInitialPath:(NSString *)soundFile;
{
    int result;
    NSOpenPanel *sharedOpenPanel = [NSOpenPanel openPanel];
    NSString *soundFilename=nil;
    NSString *soundDirectory;

    [sharedOpenPanel setAllowsMultipleSelection:NO];
    if (soundFile && [[NSFileManager defaultManager] isReadableFileAtPath:soundFile])
      {
        soundDirectory=[soundFile stringByDeletingLastPathComponent];
        soundFilename=[soundFile lastPathComponent];
      }
    else
        soundDirectory=NSHomeDirectory();
    result = [sharedOpenPanel runModalForDirectory:soundDirectory file:soundFilename types:[NSArray arrayWithObject:@"snd"]];
    if (result == NSOKButton)
      {
        return [[sharedOpenPanel filenames] lastObject];
      }
    return nil;
}

- (void)selectedSetCompressionSoundPathButton:sender;
{
    NSString *soundFile;

    soundFile=[self showPanelForSoundWithInitialPath:[[NSUserDefaults standardUserDefaults] stringForKey:@"CompressionSound"]];
    if (soundFile)
      {
        [[NSUserDefaults standardUserDefaults] setObject:soundFile
                                                  forKey:@"CompressionSound"];
        [self syncPreferencesPanelToCurrentSettings];
      }
}

- (void)selectedSetDecompressionSoundPathButton:sender;
{
    NSString *soundFile;

    soundFile=[self showPanelForSoundWithInitialPath:[[NSUserDefaults standardUserDefaults] stringForKey:@"DecompressionSound"]];
    if (soundFile)
      {
        [[NSUserDefaults standardUserDefaults] setObject:soundFile
                                                  forKey:@"DecompressionSound"];
        [self syncPreferencesPanelToCurrentSettings];
      }
}




- (void)selectedShowCompressionPanelCheckbox:sender;
{
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"ShowPanelWhenCompressionFinishes"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)selectedSelectInWorkspaceAfterCompressionCheckbox:sender;
{
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"SelectInWorkspaceAfterCompress"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)selectedShowDecompressionPanelCheckbox:sender;
{
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"ShowPanelWhenDecompressionFinishes"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)selectedSelectInWorkspaceAfterDecompressionCheckbox:sender;
{
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"SelectInWorkspaceAfterDecompress"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}




- (void)selectedPlayCompressionSoundCheckbox:sender;
{
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"PlayCompressionSound"];
    [self syncPreferencesPanelToCurrentSettings];
}

- (void)selectedPlayDecompressionSoundCheckbox:sender;
{
    [[NSUserDefaults standardUserDefaults] setBool:([sender intValue] == 1) forKey:@"PlayDecompressionSound"];
    [self syncPreferencesPanelToCurrentSettings];
}

- (void)takeValueFromCompressionField:sender;
{
    [[NSUserDefaults standardUserDefaults] setObject:[compressionSoundField stringValue]
                                                   forKey:@"CompressionSound"];
    [self syncPreferencesPanelToCurrentSettings];
}

- (void)takeValueFromDecompressionField:sender;
{
    [[NSUserDefaults standardUserDefaults] setObject:[decompressionSoundField stringValue]
                                                   forKey:@"DecompressionSound"];
    [self syncPreferencesPanelToCurrentSettings];
}


@end
