/* FileDeletePanelController.m created by sanguish on Fri 18-Dec-1998 */

#import "FileDeletePanelController.h"

#define FILE_DELETE_PANEL__YES_BUTTON 0
#define FILE_DELETE_PANEL__NO_BUTTON 1
#define FILE_DELETE_PANEL__CANCEL_BUTTON 2
#define FILE_DELETE_PANEL__CHECKBOX_KEY @"Delete"
#define FILE_DELETE_PANEL__FILENAME_KEY @"Filename"
#define FILE_DELETE_PANEL__PATH_KEY @"Path"


@implementation FileDeletePanelController

- initWithPromptedFiles:(NSArray *)array
{
    if ([self init])
      {
        if ([NSBundle loadNibNamed:@"FileDeletePanel" owner:self])
          {
            [self setFilesArray:[NSMutableArray array]];
            [self setPromptedFiles:array];
          }
        else
          {
            [self release];
            return nil;
          }
      }
    return self;
}


- (void)disableCancelButton
{
    [cancelButton setEnabled:NO];
}


- (void)dealloc
{
    [filesArray release];
    [super dealloc];
}

- (void)setFilesArray:(NSMutableArray *)array
{
    [filesArray release];
    filesArray=[array retain];
}


- (void)setPromptedFiles:(NSArray *)array
{
    NSEnumerator *overArray;
    NSString *eachItem;
    NSMutableArray *newArray;
    int defaultDeleteValue;


    defaultDeleteValue=(int)[[NSUserDefaults standardUserDefaults] boolForKey:@"DefaultDeleteValueIsYes"];
    newArray=[NSMutableArray array];
    overArray=[array objectEnumerator];
    while (( eachItem = [overArray nextObject] ))
      {
        NSMutableDictionary *theDict;

        theDict=[NSMutableDictionary dictionary];
        [theDict setObject:[NSNumber numberWithInt:defaultDeleteValue] forKey:FILE_DELETE_PANEL__CHECKBOX_KEY];
        [theDict setObject:[eachItem stringByAbbreviatingWithTildeInPath] forKey:FILE_DELETE_PANEL__FILENAME_KEY];
        [theDict setObject:eachItem forKey:FILE_DELETE_PANEL__PATH_KEY];
        [newArray addObject:theDict];
      }
    [self setFilesArray:newArray];
    return;
}

- (NSArray *)checkedFiles
{
    NSMutableArray *tempArray;
    NSEnumerator *overArray;
    NSMutableDictionary *eachItem;

    tempArray=[NSMutableArray array];
    overArray=[filesArray objectEnumerator];

    while (( eachItem = [overArray nextObject] ))
      {
        if ([[eachItem objectForKey:FILE_DELETE_PANEL__CHECKBOX_KEY] intValue] > 0)
            [tempArray addObject:[eachItem objectForKey:FILE_DELETE_PANEL__PATH_KEY]];
      }
    return tempArray;
}

- (void)uncheckAllFiles
{
    [self setCheckOnAllFilesTo:0];
}

- (void)checkAllFiles
{
    [self setCheckOnAllFilesTo:1];
}


- (void)setCheckOnAllFilesTo:(int)val
{
    NSEnumerator *overArray;
    NSMutableDictionary *eachItem;

    overArray=[filesArray objectEnumerator];

    while (( eachItem = [overArray nextObject] ))
        [eachItem setObject:[NSNumber numberWithInt:val] forKey:FILE_DELETE_PANEL__CHECKBOX_KEY];
    return;
}

- (void)awakeFromNib
{
    NSTableColumn *checkboxColumn;

    checkboxColumn=[tableView tableColumnWithIdentifier:FILE_DELETE_PANEL__CHECKBOX_KEY];
    if (checkboxColumn)
      {
        NSButtonCell *protoCell;

        protoCell=[NSButtonCell new];
        [protoCell setButtonType:NSSwitchButton];
        [protoCell setImagePosition:NSImageOnly];
        [protoCell setTitle:@""];
        [checkboxColumn setDataCell:protoCell];

        [checkboxColumn setWidth:20];
        [checkboxColumn setMinWidth:20];
        [checkboxColumn setMaxWidth:20];
        [checkboxColumn setResizable:NO];
      }
    [tableView setHeaderView:nil];
    [tableView setAction:@selector(clicked:)];
    [tableView setTarget:self];
    [tableView reloadData];
    return;
}

- (void)clicked:sender
{
    int clickedRow;
    int clickedColumn;

    clickedRow=[tableView clickedRow];
    clickedColumn=[tableView clickedColumn];

    if (![[[[tableView tableColumns] objectAtIndex:clickedColumn] identifier] isEqual:FILE_DELETE_PANEL__CHECKBOX_KEY])
      {
        NSMutableDictionary *theRecord;
        BOOL currentValue;

        theRecord = [filesArray objectAtIndex:clickedRow];
        currentValue=[[theRecord objectForKey:FILE_DELETE_PANEL__CHECKBOX_KEY] boolValue];
        [theRecord setObject:[NSNumber numberWithBool:!currentValue] forKey:FILE_DELETE_PANEL__CHECKBOX_KEY];
        [tableView reloadData];
      }
}

- (void)yesButtonClicked:sender
{
    [NSApp stopModalWithCode:FILE_DELETE_PANEL__YES_BUTTON];
}

- (void)noButtonClicked:sender
{
    [NSApp stopModalWithCode:FILE_DELETE_PANEL__NO_BUTTON];
    [self uncheckAllFiles];
}

- (void)cancelButtonClicked:sender
{
    [NSApp stopModalWithCode:FILE_DELETE_PANEL__CANCEL_BUTTON];
    [self uncheckAllFiles];
}

- (BOOL)run
{
    int i;

    [thePanel center];
    [tableView reloadData];
    i=[NSApp runModalForWindow:thePanel];
    [thePanel orderOut:self];
    return (i != FILE_DELETE_PANEL__CANCEL_BUTTON);
}



- (void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
    [[filesArray objectAtIndex:rowIndex] setObject:anObject forKey:[aTableColumn identifier]];
}




- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
    id theRecord;

    if (aTableView == tableView)
      {
        NSParameterAssert(rowIndex >= 0 && rowIndex < [filesArray count]);
        theRecord = [filesArray objectAtIndex:rowIndex];
        return [theRecord objectForKey:[aTableColumn identifier]];
      }

    return nil;
}


- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
    if (aTableView == tableView)
        return [filesArray count];
    return -1;
}


@end
