/* DFProgressPanel.m created by sanguish on Tue 03-Nov-1998 */

#import "DFProgressPanel.h"

@implementation DFProgressPanel

+ (id)sharedInstance
{
    static DFProgressPanel *_sharedDFProgressPanel = nil;


    if (!_sharedDFProgressPanel) {
        _sharedDFProgressPanel = [[DFProgressPanel allocWithZone:[self zone]] init];
    }
    return _sharedDFProgressPanel;
}

- (NSWindow *)window
{
    return window;
}


- (id)init
{
    if ([super init])
      {
        [NSBundle loadNibNamed:@"ProgressPanel" owner:self];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(progressPanelUpdateNofication:)
                                                     name:DFProgressPanelUpdateNotification
                                                   object:nil];
      }
    return self;
}

- (void)awakeFromNib
{
#ifdef WIN32
    [[self window] setMenu:nil];
#endif
}

- (void)startAnimation
{
    [progressIndicator startAnimation:self];
}

- (void)setProgressMaxValue:(double)val
{
    [progressIndicator setMaxValue:val];
    [progressIndicator displayIfNeeded];
}

- (void)animate
{
    [progressIndicator animate:self];
    [progressIndicator displayIfNeeded];
}


- (void)setProgressLabel:(NSString *)val
{
    [titleField setStringValue:val];
    [titleField displayIfNeeded];
    [[NSDPSContext currentContext] flush];
}

- (void)setProgressIndeterminate:(BOOL)val
{
    [progressIndicator setIndeterminate:val];
//    [progressIndicator setUsesThreadedAnimation:val];
    [progressIndicator displayIfNeeded];
}

- (void)setProgressValue:(double)val
{
    [progressIndicator setDoubleValue:val];
    [progressIndicator displayIfNeeded];
}


- (void)progressPanelUpdateNofication:(NSNotification *)notification
{
    NSDictionary *theDict;
    NSString *progressPanelLabel;
    double maximumValue;
    double currentValue;
    BOOL isIndeterminate;

    theDict=[notification userInfo];

    progressPanelLabel=[theDict objectForKey:DFProgressPanelLabel];
    if (!progressPanelLabel)
        progressPanelLabel=@"";

    maximumValue=[theDict objectForKey:DFProgressPanelMaximum] ? [[theDict objectForKey:DFProgressPanelMaximum] doubleValue] : NSNotFound;
    currentValue=[theDict objectForKey:DFProgressPanelCurrent] ? [[theDict objectForKey:DFProgressPanelCurrent] doubleValue] : NSNotFound;
    isIndeterminate=[theDict objectForKey:DFProgressPanelIndeterminate] ? YES : NO;

    [progressIndicator setIndeterminate:isIndeterminate];
    if (maximumValue == NSNotFound)
        [self setProgressMaxValue:100.0];
    else
        [self setProgressMaxValue:maximumValue];

    if (currentValue == NSNotFound && isIndeterminate)
        [progressIndicator startAnimation:self];
    else
        [self setProgressValue:currentValue];

    [self setProgressLabel:progressPanelLabel];
    
    [self showWindow:self];
}

- (void)setPanelTitle:(NSString *)theString
{
    [[self window] setTitle:theString];
}


- (IBAction)showWindow:(id)sender
{
    [[self window] center];
    [[self window] makeKeyAndOrderFront:self];
    [[self window] display];
}


- (IBAction)hideWindow:(id)sender
{
    [progressIndicator stopAnimation:self];
    [[self window] orderOut:self];

}

- (void)dealloc;
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

@end
