/*
 File:       ApplicationDelegate+infopanel.m
 Written By: Scott Anguish
 Created:    Dec 9, 1997
 Copyright:  Copyright 1997 by Scott Anguish, all rights reserved.
*/

#import "ApplicationDelegate.h"
#import "NSColor+utils.h"

@implementation ApplicationDelegate(infopanel)


- (void)setupForInfoPanel
{
/*
    NSAttributedString *tempString;
    
    [infoPanelScrollingText setDelegate:self];
    tempString=[[[NSAttributedString alloc] initWithHTML:[NSData dataWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"Info" ofType:@"html"]] baseURL:[NSURL URLWithString:@"http://www.stepwise.com/"] documentAttributes:NULL] autorelease];
    [[infoPanelScrollingText textStorage] setAttributedString:tempString];
 */
}
    
- showInfoPanel:sender;
{
    // Its becoming a pain keeping the info panel which outlines
    // the capabilities of the application in sync with its
    // capabilities, across both OpenStep and Rhapsody as well,
    // every time I make a release, I need to open up IB to change
    // the release number time to fix that
    NSString *version=[[NSBundle mainBundle] pathForResource:@"version" ofType:@""];
    NSString *versionFormat=[infoPanelTextField stringValue];
    
    [infoPanelTextField setStringValue:[NSString stringWithFormat:versionFormat,[NSString stringWithContentsOfFile:version]]];
    [infoPanel center];
    [infoPanel makeKeyAndOrderFront:self];
    return self;
}

- (BOOL)textView:(NSTextView *)textView clickedOnLink:(id)link atIndex:(unsigned)charIndex
{
    NSLog(@"link - %@",link);
    return NO;
}



- showFormatsPanel:sender;
{
    NSString *dataFontName;
    
    // Its becoming a pain keeping the info panel which outlines
    // the capabilities of the application in sync with its
    // capabilities, across both OpenStep and Rhapsody as well,
    // every time I make a release, I need to open up IB to change
    // the release number time to fix that

    if (!infoPanelSupportedTypes)
        infoPanelSupportedTypes=[[self infoAboutSupportedFileExtensions] retain];

    [infoTableView setBackgroundColor:[NSColor tanTextBackgroundColor]];


    dataFontName=[[[[infoTableView tableColumnWithIdentifier:@"tools"] dataCell] font] fontName];
    [[[infoTableView tableColumnWithIdentifier:@"tools"] dataCell] setFont:[NSFont fontWithName:dataFontName size:10]];
    [[[infoTableView tableColumnWithIdentifier:@"extensions"] dataCell] setFont:[NSFont fontWithName:dataFontName size:10]];
    [[[infoTableView tableColumnWithIdentifier:@"comments"] dataCell] setFont:[NSFont fontWithName:dataFontName size:10]];

    [infoTableView setDataSource:infoPanelSupportedTypes];
    [infoTableView reloadData];

    [formatsPanel makeKeyAndOrderFront:self];
    return self;
}

- (NSArray *)infoAboutSupportedFileExtensions;
{
    NSEnumerator *overFileTypes;
    NSDictionary *eachFileType;
    NSMutableArray *outputArray=[NSMutableArray array];
    NSMutableDictionary *tempDict;

    overFileTypes=[fileTypeConfigArray objectEnumerator];
    while (eachFileType = [overFileTypes nextObject])
      {
        id extensions = [eachFileType objectForKey:@"file_extension"];
        id tools;

        if ([eachFileType objectForKey:@"wrapped_programs"])
          {
            id wrappedTools;

            if ([[eachFileType objectForKey:@"wrapped_programs"] isKindOfClass:[NSArray class]])
                wrappedTools=[eachFileType objectForKey:@"wrapped_programs"];
            else
                wrappedTools=[NSArray arrayWithObject:[eachFileType objectForKey:@"wrapped_programs"]];

                tools=[wrappedTools componentsJoinedByString:@","];
          }
        else
            tools=@"";

        if ( [extensions isKindOfClass:[NSArray class]])
          {
            int i;
            for (i=0; i < [extensions count]; i++)
              {
                id comments=[eachFileType objectForKey:@"Comments"];
                if ([comments isKindOfClass:[NSDictionary class]])
                    comments=[[eachFileType objectForKey:@"Comments"] objectForKey:[extensions objectAtIndex:i]];
                comments=[[NSBundle mainBundle] localizedStringForKey:[extensions objectAtIndex:i]
                                                                value:comments
                                                                table:@"filesConfigComments"];
                tempDict=[NSMutableDictionary dictionary];
                [tempDict setObject:[extensions objectAtIndex:i] forKey:@"extensions"];
                [tempDict setObject:tools forKey:@"tools"];
                if (comments)
                    [tempDict setObject:comments forKey:@"comments"];
                else
                    [tempDict setObject:@"" forKey:@"comments"];

                [outputArray addObject:tempDict];
              }
          }
        else
          {
            id comments;
            
            comments=[[NSBundle mainBundle] localizedStringForKey:extensions
                                                            value:[eachFileType objectForKey:@"Comments"]
                                                            table:@"filesConfigComments"];

            tempDict=[NSMutableDictionary dictionary];
            [tempDict setObject:extensions forKey:@"extensions"];
            [tempDict setObject:tools forKey:@"tools"];
            if (comments)
                [tempDict setObject:comments forKey:@"comments"];
            else
                [tempDict setObject:@"" forKey:@"comments"];
            
            [outputArray addObject:tempDict];
          }
      }
    return [NSArray arrayWithArray:outputArray];
}

- openURL:(NSString *)string
{
    NSString *urlString=[NSString stringWithString:string];

    [self performSelector: @selector(performOpenUrl:) withObject: urlString afterDelay: 0.0];
    return self;
}


- performOpenUrl:(NSString *)urlName;
{
    NSPasteboard 	*pboard;
    NSArray		*urlPboardTypes;
    NSString 		*serviceName;

    pboard = [NSPasteboard pasteboardWithName:@"URLServicePasteboard"];
    urlPboardTypes = [NSArray arrayWithObjects:NSStringPboardType, nil];
    [pboard declareTypes:urlPboardTypes owner:nil];
    [pboard setString:urlName forType:NSStringPboardType];

    if((serviceName = [[NSUserDefaults standardUserDefaults] stringForKey:@"URLService"]) == nil)
        serviceName = @"OmniWeb/Open URL";
    NSPerformService(serviceName, pboard);
    return self;
}

- showStepwiseInOmniWeb:sender;
{
    [self openURL:@"http://www.stepwise.com/"];
    return self;
}


- showPAndLInOmniWeb:sender;
{
    [self openURL:@"http://www.plsys.co.uk/"];
    return self;
}

- mailSanguish:sender;
{
    [self mailto:@"sanguish@digifix.com"];
    return self;
}


- mailPAndL:sender;
{
    [self mailto:@"info@plsys.co.uk"];
    return self;
}

- mailto:sender;
{
    NSPasteboard 	*pboard;
    NSArray		*urlPboardTypes;
    NSString 		*serviceName=@"MailViewer/Mail To";

    pboard = [NSPasteboard pasteboardWithName:@"MailViewerServicePasteboard"];
    urlPboardTypes = [NSArray arrayWithObjects:NSStringPboardType, nil];
    [pboard declareTypes:urlPboardTypes owner:nil];
    [pboard setString:sender forType:NSStringPboardType];
    NSPerformService(serviceName, pboard);
    return self;
}

@end
