#include "dbench.h"

/* this creates the specified number of child processes and runs fn() in all of them */
static double create_procs(int nprocs, void (*fn)(int ))
{
	int i, status;
	volatile int *child_status;
	int synccount;
        int sharedmem_size;

	start_timer();

	synccount = 0;
        sharedmem_size = sizeof(int)*nprocs;

        child_status = (volatile int *)shm_setup(sharedmem_size);
	if (!child_status) {
		printf("Failed to setup shared memory\n");
		return end_timer();
	}

	memset((void *)child_status, 0, sizeof(int)*nprocs);

	for (i=0;i<nprocs;i++) {
		if (fork() == 0) {
			child_status[i] = getpid();

			while (child_status[i]) sleep(0);

			setbuffer(stdout, NULL, 0);

			fn(i);
			_exit(0);
		}
	}

	do {
		synccount = 0;
		for (i=0;i<nprocs;i++) {
			if (child_status[i]) synccount++;
		}
		if (synccount == nprocs) break;
		sleep(0);
	} while (end_timer() < 30);

	if (synccount != nprocs) {
		printf("FAILED TO START %d CLIENTS (started %d)\n", nprocs, synccount);
		return end_timer();
	}

	/* start the client load */
	start_timer();

	for (i=0;i<nprocs;i++) {
		child_status[i] = 0;
	}

	printf("%d clients started\n", nprocs);

	for (i=0;i<nprocs;i++) {
		waitpid(0, &status, 0);
		printf("*");
	}
	printf("\n");

#ifdef USE_MACH_VM_INHERIT
        vm_deallocate( task_self(), (vm_address_t)child_status, sharedmem_size );
#endif
        
	return end_timer();
}

#ifdef NO_FORK

static double do_one_child(void (*fn)(int ))
{
    printf( "running only one process\n" );
    /* start the client load */
    start_timer();

    printf("%d clients started\n", 1 );

    setbuffer(stdout, NULL, 0);

    fn(1);

    printf("\n");

    return end_timer();
}

#endif

 int main(int argc, char *argv[])
{
	int nprocs;
	double t;

	if (argc < 2) {
		printf("usage: dbench nprocs\n");
		exit(1);
	}

	nprocs = atoi(argv[1]);


#ifndef NO_FORK
	t = create_procs(nprocs, child_run);
#else
        t = do_one_child( child_run );
#endif
	/* to produce a netbench result we scale accoding to the
           netbench measured throughput for the run that produced the
           sniff that was used to produce client.txt. That run used 2
           clients and ran for 660 seconds to produce a result of
           4MBit/sec. */
	printf("Throughput %g MB/sec (NB=%g MB/sec  %g MBit/sec)\n", 
	       132*nprocs/t, 0.5*0.5*nprocs*660/t, 2*nprocs*660/t);
	return 0;
}
