#include "dbench.h"

int line_count=0;

static int sigsegv(int sig)
{
	char line[200];
	printf("segv at line %d\n", line_count);
	sprintf(line, "/usr/X11R6/bin/xterm -e gdb /proc/%d/exe %d", 
		getpid(), getpid());
	system(line);
	exit(1);
}

void child_run(int client)
{
	int sock, i;
	char fname[128];
	char line[1024];
	char cname[20];
	FILE *f;
	char *params[20];

	signal(SIGSEGV, sigsegv);

	sock = open("/dev/zero", O_RDWR);

	sprintf(cname,"CLIENT%d", client);

	f = fopen("client.txt", "r");

	if (!f) {
		perror("client.txt");
		return;
	}

	while (fgets(line, sizeof(line)-1, f)) {
		line_count++;

		line[strlen(line)-1] = 0;

		all_string_sub(line,"CLIENT1", cname);
		all_string_sub(line,"\\", "/");
		all_string_sub(line," /", " ");
		
		for (i=0;i<20;i++) params[i] = "";

		/* parse the command parameters */
		params[0] = strtok(line," ");
		i = 0;
		while (params[i]) params[++i] = strtok(NULL," ");

		params[i] = "";

		if (i < 2) continue;

		if (strcmp(params[1],"REQUEST") == 0) {
			if (!strcmp(params[0],"SMBopenX")) {
				strcpy(fname, params[5]);
			} else if (!strcmp(params[0],"SMBclose")) {
				do_close(atoi(params[3]));
			} else if (!strcmp(params[0],"SMBmkdir")) {
				do_mkdir(params[3]);
			} else if (!strcmp(params[0],"CREATE")) {
				do_create(params[3], atoi(params[5]));
			} else if (!strcmp(params[0],"SMBrmdir")) {
				do_rmdir(params[3]);
			} else if (!strcmp(params[0],"SMBunlink")) {
				strcpy(fname, params[3]);
			} else if (!strcmp(params[0],"SMBmv")) {
				do_rename(params[3], params[5]);
			} else if (!strcmp(params[0],"SMBgetatr")) {
				strcpy(fname, params[3]);
			} else if (!strcmp(params[0],"SMBwrite")) {
				do_write(atoi(params[3]), 
					 atoi(params[5]), atoi(params[7]));
			} else if (!strcmp(params[0],"SMBwritebraw")) {
				do_write(atoi(params[3]), 
					 atoi(params[7]), atoi(params[5]));
			} else if (!strcmp(params[0],"SMBreadbraw")) {
				do_read(atoi(params[3]), 
					 atoi(params[7]), atoi(params[5]));
			} else if (!strcmp(params[0],"SMBread")) {
				do_read(atoi(params[3]), 
					 atoi(params[5]), atoi(params[7]));
			}
		} else {
			if (!strcmp(params[0],"SMBopenX")) {
				if (!strncmp(params[2], "ERR", 3)) continue;
				do_open(fname, atoi(params[3]), atoi(params[5]));
			} else if (!strcmp(params[0],"SMBgetatr")) {
				if (!strncmp(params[2], "ERR", 3)) continue;
				do_stat(fname, atoi(params[3]));
			} else if (!strcmp(params[0],"SMBunlink")) {
				if (!strncmp(params[2], "ERR", 3)) continue;
				do_unlink(fname);
			}
		}
	}
	fclose(f);

	sprintf(fname,"CLIENTS/CLIENT%d", client);
	rmdir(fname);
	rmdir("CLIENTS");

	printf("+");
}
