/*+++
 *  title:      MailPopOverProxy.m
 *  abstract:   Implementation of MailPopOverProxy class for mailapp-utilities.
 *  author:     Tom Hageman <tom@basil.icce.rug.nl>
 *  created:    October 1998
 *  modified:   
 *  copyleft:
 *
 *	Copyright (C) 1998  Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *
 *      Private concrete MailProxy subclass.
 *	Implements communication with PopOver.app (and, possibly, other
 *	mail clients that implement <PDExternalComposition> protocol.)
 *---*/

static const char * const RCSid = ((void)&RCSid,
	"@(#)MailPopOverProxy.m,v 1.4 1998/12/02 00:27:53 tom Exp");
#define RCS_MailAppProxy_ID

#import "MailProxy.h"
#import <string.h>
#import <stdlib.h>

#if NEXTSTEP
 #error PopOver.app proxy not supported on NEXTSTEP.
#endif

#import "PDExternalComposition.h"

#define POPOVER_DO_NAME	   @"MailClientInterface"
#define POPOVER_DO_NAME_2  @"PopOver"


@interface MailPopOverProxy : MailProxy
{
   id <PDExternalComposition> server;
}

@end // MailPopOverProxy


@implementation MailPopOverProxy

+ (BOOL)canEditMessage		{ return YES; }
//+ (BOOL)canDeliverMessage	{ return NO; }
//+ (BOOL)canIncorporateNewMail	{ return NO; }
+ (BOOL)canSendBcc		{ return YES; }
//+ (BOOL)canSendArbitraryHeaders  { return NO; }


- (void)dealloc
{
   [server release];
   [super dealloc];
}


- (BOOL)connectToMailer
{
   NSString *host = [self hostName];
   id proxy;

   proxy = [NSConnection rootProxyForConnectionWithRegisteredName:POPOVER_DO_NAME host:host];

   if (proxy == nil)
   {
      proxy = [NSConnection rootProxyForConnectionWithRegisteredName:POPOVER_DO_NAME_2 host:host];

      if (proxy == nil) return NO;
   }

   [proxy setProtocolForProxy:@protocol(PDExternalComposition)];
   server = [proxy retain];

   return YES;
}


- (BOOL)sendMailMessageTo:(NSString *)to
   subject:(NSString *)subject
   body:(id)body
   cc:(NSString *)cc
   bcc:(NSString *)bcc
{
   NS_DURING
   {
      [server composeMessageTo:to subject:subject cc:cc bcc:bcc
	 body:[self replacementObjectForBody:body]];
      [self makeMailerActive];
   }
   NS_HANDLER
   {
      return NO;
   }
   NS_ENDHANDLER
   return isConnected;
}

@end // MailViewerProxy
