/**
 * The Rhapsody output driver
 **
 * Wilfredo Sanchez | wsanchez@apple.com, tritan@mit.edu
 *
 * Copyright 1998 Apple Computer, Inc.
 *
 * Copyright (c) 1989 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file
 * "mit-copyright.h".
 *
 * All rights reserved.
 **/

#include <zephyr/mit-copyright.h>

#include <sysdep.h>

#include <new_string.h>
#include <formatter.h>
#include <variables.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "ZephyrMessage.h"
#import "ZephyrClient.h"

#include "message_parser.h"
#include "zwgc_driver.h"

/**
 * Initialize the driver
 **/

int NS_driver_init (char* aDrivername, char aNotFirst, int* anArgc, char** anArgv)
{
    return 0;
}

/**
 * Reset the driver
 **/

void NS_driver_reset ()
{
}

/**
 * Display
 **/

#define getvariable(aVariable)							\
        if ((aValue = var_get_variable(aVariable)))	 			\
            [aMessageInfo setObject: [NSString stringWithCString: aValue]	\
                             forKey: @ ## aVariable]

char* NS_driver (string anInput)
{
    NSAttributedString*  aMessageText = nil;
    NSMutableDictionary* aMessageInfo = [NSMutableDictionary dictionary];

    ////
    // Populate the info dictionary
    ////
    {
        string aValue = "";

        getvariable("date"     );
        getvariable("time"     );
        getvariable("class"    );
        getvariable("instance" );
        getvariable("recipient");
        getvariable("opcode"   );
        getvariable("auth"     );
        getvariable("sender"   );
        getvariable("signature");
        getvariable("fromhost" );
    }

    ////
    // Parse the input
    ////
    // Since we can deal with HTML rather easily, and it would be cool to be able to send HTML
    //   zephyrgrams, let's allow users to do so by setting the message opcode to "HTML". This
    //   feels like an "embrace and extend" tactic, since other zephyr clients won't interoperate,
    //   but maybe that should be fixed, since it's kind of a cool feature.
    // Unfortunately, this breaks the usual .zwgc.desc header spewage, which tends to include
    //   scribe-format text.
    ////
    {
        if ([[[aMessageInfo objectForKey: @"opcode"] uppercaseString] isEqualToString: @"HTML"])
            aMessageText = attributedStringFromHTMLText(anInput);
        else
            aMessageText = attributedStringFromScribeText(anInput);
    }

    ////
    // Pass the message up to the zephyr client
    ////
    {
        [ZephyrClient dispatchMessage: [ZephyrMessage messageWithInfo: aMessageInfo
                                                                 text: aMessageText]];
    }

    return NULL;
}
