/**
 * Zephyr Message
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **
 * A ZephyrMessage is contains an attributed string, and a dictionary with information
 * about the message. A ZephyrMessage object is typically created by the zwgc driver;
 * the zwgc driver therefore determined what sort of data is put into the info dictionary.
 **/

#import <Foundation/NSObject.h>

@class NSString;
@class NSAttributedString;
@class NSDictionary;

@interface ZephyrMessage : NSObject

/**********************
 * Instance Variables *
 **********************/

{
@private
    NSDictionary*       myInfo;
    NSAttributedString* myText;
}

/*****************
 * Class Methods *
 *****************/

////
// Factories
///

+ (ZephyrMessage*) messageWithInfo: (NSDictionary      *) anInfo
                              text: (NSAttributedString*) aText;

/********************
 * Instance Methods *
 ********************/

////
// Inits
////

- (id) initWithInfo: (NSDictionary*      ) anInfo
               text: (NSAttributedString*) aText;

////
// Accessors
////

- (NSDictionary*      ) info;
- (NSAttributedString*) text;
- (NSString*          ) date;
- (NSString*          ) time;
- (NSString*          ) zephyrClass;
- (NSString*          ) zephyrInstance;
- (NSString*          ) recipient;
- (NSString*          ) opcode;
- (NSString*          ) auth;
- (NSString*          ) sender;
- (NSString*          ) signature;
- (NSString*          ) fromhost;
- (NSString*          ) description;

////
// Actions
////

- (BOOL) ping;
- (BOOL) send;

@end
