/**
 * Zephyr Message Client
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **
 * The ZephyrClient class launches the zwgc driver and receives messages from
 * it, which is then forwarded to it's delegate.
 *
 * runMessageLoop: runs a Zephyr client identical to the zwgc(1) client which
 * may be run in a tty session or in X Windows with the "NS" output driver,
 * which is implemented in zwgc_driver.m. runMessageLoop: is typically run as
 * the detached selector in a thread; it does not exit until the zwgc code does.
 **/

#import <Foundation/NSObject.h>

@class NSString;

@class MessageBrowser;
@class ZephyrMessage;

#import "ZephyrViewer.h"

@interface ZephyrClient : NSObject

/**********************
 * Instance Variables *
 **********************/

{
}

/*****************
 * Class Methods *
 *****************/

////
// Accessors
////

+ (id <ZephyrViewer>) delegate;

+ (NSString*) defaultZephyrClass;
+ (NSString*) defaultZephyrInstance;
+ (NSString*) defaultOpcode;
+ (NSString*) defaultSignature;

+ (NSString*) errorMessageForCode: (int) anErrorCode;

////
// Actions
////

+ (void) runMessageLoop : (id <ZephyrViewer>) aDelegate;
+ (void) dispatchMessage: (ZephyrMessage*   ) aMessage;

@end
